#include "paramswidget.h"
#include "elddisp.h"
#include "rmixcheckbox.h"
#include "rmixenumbox.h"
#include "rmixnumspin.h"
#include "t5disp.h"
#include <QLabel>
#include <QScrollArea>
#include <QTimer>

ParamsWidget::ParamsWidget(CardSelector *cs) {
	m_wOut= new QWidget;
	m_wOut->setObjectName("wOut");
	m_lOut= new QVBoxLayout(m_wOut);
	QScrollArea *sOut= new QScrollArea();
	sOut->setWidgetResizable(1);
	sOut->setWidget(m_wOut);
	addTab(sOut, QIcon::fromTheme("audio-volume-high"), "Outputs");

	m_wIn= new QWidget;
	m_wIn->setObjectName("wIn");
	m_lIn= new QVBoxLayout(m_wIn);
	QScrollArea *sIn= new QScrollArea();
	sIn->setWidgetResizable(1);
	sIn->setWidget(m_wIn);
	addTab(sIn, QIcon::fromTheme("audio-input-microphone"), "Inputs");

	m_wInt= new QWidget;
	m_wInt->setObjectName("wInt");
	m_lInt= new QVBoxLayout(m_wInt);
	QScrollArea *sInt= new QScrollArea();
	sInt->setWidgetResizable(1);
	sInt->setWidget(m_wInt);
	addTab(sInt, "Internal");

	m_wMix= new QWidget;
	m_wMix->setObjectName("wMix");
	m_lMix= new QVBoxLayout(m_wMix);
	QScrollArea *sMix= new QScrollArea();
	sMix->setWidgetResizable(1);
	sMix->setWidget(m_wMix);
	addTab(sMix, "Routing");

	m_wDig= new QWidget;
	m_wDig->setObjectName("wDig");
	m_lDig= new QVBoxLayout(m_wDig);
	QScrollArea *sDig= new QScrollArea();
	sDig->setWidgetResizable(1);
	sDig->setWidget(m_wDig);
	addTab(sDig, "Digital");

	m_wMisc= new QWidget;
	m_wMisc->setObjectName("wMisc");
	m_lMisc= new QVBoxLayout(m_wMisc);
	QScrollArea *sMisc= new QScrollArea();
	sMisc->setWidgetResizable(1);
	sMisc->setWidget(m_wMisc);
	addTab(sMisc, "Misc");

	m_timer= new QTimer;
	m_mixer= nullptr;
	m_cs= cs;
}

ParamsWidget::~ParamsWidget() {
	clear();
}

void ParamsWidget::update() {
	clear();
	for(ushort i= 0; i < count(); i++)
		setTabVisible(i, 1);
	populate();
}

void ParamsWidget::clear() {
	m_timer->stop();
	disconnect(m_mixer, SLOT(updat()));
	QLayoutItem *oldItem;
	while((oldItem= m_lOut->takeAt(0)) != nullptr)
	{
		delete oldItem->widget();
		delete oldItem;
	}
	while((oldItem= m_lIn->takeAt(0)) != nullptr)
	{
		delete oldItem->widget();
		delete oldItem;
	}
	while((oldItem= m_lInt->takeAt(0)) != nullptr)
	{
		delete oldItem->widget();
		delete oldItem;
	}
	while((oldItem= m_lMix->takeAt(0)) != nullptr)
	{
		delete oldItem->widget();
		delete oldItem;
	}
	while((oldItem= m_lDig->takeAt(0)) != nullptr)
	{
		delete oldItem->widget();
		delete oldItem;
	}
	while((oldItem= m_lMisc->takeAt(0)) != nullptr)
	{
		delete oldItem->widget();
		delete oldItem;
	}
	snd_ctl_elem_info_free(m_info);
	delete m_mixer;
}

void ParamsWidget::populate() {
	m_mixer= new mixerHandle(m_cs->currentData().toInt());
	snd_ctl_elem_info_malloc(&m_info);
	snd_hctl_elem_t *elem;
	QString elemName, index;
	ushort numCh;
	bool lbNoteInt= 0;

	QGroupBox *gbChmap= new QGroupBox("Channel Mapping");
	gbChmap->setObjectName("Channel Mapping");
	m_lChmap= new QFormLayout(gbChmap);
	gbChmap->setVisible(0);
	m_lMisc->addWidget(gbChmap);

	QWidget *wJacks= new QWidget();
	QHBoxLayout *lJacks= new QHBoxLayout(wJacks);
	lJacks->setContentsMargins(0, 0, 0, 0);
	wJacks->setVisible(0);
	QGroupBox *gbJacksIn= new QGroupBox("Input Jack Sensors", wJacks);
	QGroupBox *gbJacksOut= new QGroupBox("Output Jack Sensors", wJacks);
	gbJacksIn->setObjectName("Input Jack Sensors");
	gbJacksOut->setObjectName("Output Jack Sensors");
	m_lJacksIn= new QFormLayout(gbJacksIn);
	m_lJacksOut= new QFormLayout(gbJacksOut);
	lJacks->addWidget(gbJacksIn);
	lJacks->addWidget(gbJacksOut);
	m_lMisc->addWidget(wJacks);

	// iterate thru elements
	elem= snd_hctl_first_elem(m_mixer->m_hctl);
	for(ushort i= 0; i < m_mixer->m_elemCount; i++)
	{
		QString elemName= snd_hctl_elem_get_name(elem);
		index= " " + QString::number(snd_hctl_elem_get_index(elem));
		snd_hctl_elem_info(elem, m_info);
		numCh= snd_ctl_elem_info_get_count(m_info);

		// Jack sensor
		if(elemName.endsWith("Jack"))
		{
			if(index == " 0")
				index= "";
			wJacks->setVisible(1);
			if(isInput(elemName))
				addMiscJack(m_lJacksIn, elem, elemName, index, numCh);
			else
				addMiscJack(m_lJacksOut, elem, elemName, index, numCh);
		}

		// IEC958
		else if(elemName.contains("IEC958") || elemName.contains("SPDIF"))
		{
			if(!elemName.endsWith("Mask")) // masks are rescanned inside t5disp on activat
			{
				QFormLayout *lBox= ensureMiscBox("S/PDIF and AES3", m_lDig);
				if(elemName.endsWith("Jack"))
					addMiscJack(lBox, elem, elemName, index, numCh);
				else if(elemName.endsWith("Switch"))
				{
					elemName.remove(0, elemName.indexOf(' ') + 1);
					addMiscEntry(lBox, elem, elemName.first(elemName.lastIndexOf(' ')) + index, numCh);
				} else
				{
					elemName.remove(0, elemName.indexOf(' ') + 1);
					addMiscEntry(lBox, elem, elemName + index, numCh);
				}
			}
		}

		// Channel Map
		else if(elemName.endsWith("Channel Map"))
		{
			gbChmap->setVisible(1);
			if(elemName.startsWith("Capture"))
				addMiscEntry(m_lChmap, elem, "Dev " + QString::number(snd_ctl_elem_info_get_device(m_info)) + ' ' + "Input" + index, numCh);
			else
				addMiscEntry(m_lChmap, elem, "Dev " + QString::number(snd_ctl_elem_info_get_device(m_info)) + ' ' + "Output" + index, numCh);
		}

		else
		{
			if(index == " 0")
				index= "";

			// ELD
			if(elemName == "ELD")
			{
				QFormLayout *lBox= ensureMiscBox("HDMI and DisplayPort", m_lDig);
				lBox->addRow("Dev " + QString::number(snd_ctl_elem_info_get_device(m_info)) + ' ' + elemName + index, new eldDisp(elem));
			}

			// Channel slider
			else if(elemName.endsWith("Volume"))
			{
				if(index == " 0")
					index= "";
				elemName= elemName.first(elemName.lastIndexOf(' '));

				// Boost slider
				if(elemName.contains("Boost"))
				{
					if(elemName.endsWith("Playback"))
						ensureSlBox(elemName.first(elemName.indexOf(" Boost")), rmixSliderBox::MONGAIN, m_wIn)->addSlider(elem, numCh, rmixSliderBox::MONGAIN);
					else
						ensureSlBox(elemName.first(elemName.indexOf(" Boost")), rmixSliderBox::GAIN, m_wIn)->addSlider(elem, numCh, rmixSliderBox::GAIN);
				}

				// Output/monitor slider
				else if(elemName.endsWith("Playback"))
				{
					elemName= elemName.first(elemName.lastIndexOf(' '));
					if(elemName == "PCM")
					{
						lbNoteInt= 1;
						ensureSlBox(elemName + index + " *", rmixSliderBox::NORMAL, m_wInt)->addSlider(elem, numCh, rmixSliderBox::NORMAL);
					} else if(isInput(elemName))
						ensureSlBox(elemName + index, rmixSliderBox::MONITOR, m_wIn)->addSlider(elem, numCh, rmixSliderBox::MONITOR);
					else if(isInternal(elemName))
						ensureSlBox(elemName + index, rmixSliderBox::MONITOR, m_wInt)->addSlider(elem, numCh, rmixSliderBox::MONITOR);
					else
						ensureSlBox(elemName + index, rmixSliderBox::NORMAL, m_wOut)->addSlider(elem, numCh, rmixSliderBox::NORMAL);
				} else if(elemName.endsWith("Capture"))
				{
					if(elemName == "Capture")
						ensureSlBox(elemName + index, rmixSliderBox::NORMAL, m_wIn)->addSlider(elem, numCh, rmixSliderBox::NORMAL);
					else
						ensureSlBox(elemName.first(elemName.lastIndexOf(' ')) + index, rmixSliderBox::NORMAL, m_wIn)->addSlider(elem, numCh, rmixSliderBox::NORMAL);
				} else
					ensureSlBox(elemName + index, rmixSliderBox::NORMAL, m_wMisc)->addSlider(elem, numCh, rmixSliderBox::NORMAL);
			}

			// Channel checkbox
			else if(elemName.endsWith("Switch"))
			{
				if(index == " 0")
					index= "";
				elemName= elemName.first(elemName.lastIndexOf(' '));
				if(elemName.contains("Boost"))
				{
					if(elemName.endsWith("Playback"))
						ensureSlBox(elemName.first(elemName.indexOf(" Boost")), rmixSliderBox::MONGAIN, m_wIn)->addSwitch(elem, numCh, rmixSliderBox::MONGAIN);
					else
						ensureSlBox(elemName.first(elemName.indexOf(" Boost")), rmixSliderBox::GAIN, m_wIn)->addSwitch(elem, numCh, rmixSliderBox::GAIN);
				} else if(elemName.endsWith("Playback"))
				{
					elemName= elemName.first(elemName.lastIndexOf(' '));
					if(elemName == "PCM")
					{
						lbNoteInt= 1;
						ensureSlBox(elemName + index + " *", rmixSliderBox::NORMAL, m_wInt)->addSwitch(elem, numCh, rmixSliderBox::NORMAL);
					} else if(isInput(elemName))
						ensureSlBox(elemName + index, rmixSliderBox::MONITOR, m_wIn)->addSwitch(elem, numCh, rmixSliderBox::MONITOR);
					else if(isInternal(elemName))
						ensureSlBox(elemName + index, rmixSliderBox::MONITOR, m_wInt)->addSwitch(elem, numCh, rmixSliderBox::MONITOR);
					else
						ensureSlBox(elemName + index, rmixSliderBox::NORMAL, m_wOut)->addSwitch(elem, numCh, rmixSliderBox::NORMAL);
				} else if(elemName.endsWith("Capture"))
				{
					if(elemName.startsWith("PCM"))
						addMiscEntry(ensureMiscBox("Routing", m_lMix), elem, "PCM loopback capture" + index, numCh);
					else if(elemName == "Capture")
						ensureSlBox(elemName + index, rmixSliderBox::NORMAL, m_wIn)->addSwitch(elem, numCh, rmixSliderBox::NORMAL);
					else if(elemName == "Digital In Capture")
						ensureSlBox("Generic Input" + index, rmixSliderBox::NORMAL, m_wIn)->addSwitch(elem, numCh, rmixSliderBox::NORMAL);
					else
						ensureSlBox(elemName.first(elemName.lastIndexOf(' ')) + index, rmixSliderBox::NORMAL, m_wIn)->addSwitch(elem, numCh, rmixSliderBox::NORMAL);
				} else
					ensureSlBox(elemName.first(elemName.lastIndexOf(' ')) + index, rmixSliderBox::NORMAL, m_wMisc)->addSwitch(elem, numCh, rmixSliderBox::NORMAL);
			}

			// Routing stuff
			else if(elemName.endsWith("Mode"))
			{
				if(elemName == "Channel Mode")
					addMiscEntry(ensureMiscBox("Routing", m_lMix), elem, "Output Configuration" + index, numCh);
				else if(elemName == "Auto-Mute Mode")
					addMiscEntry(ensureMiscBox("Routing", m_lMix), elem, "Mute by Headphone" + index, numCh);
				else
					addMiscEntry(ensureMiscBox("Routing", m_lMix), elem, elemName + index, numCh);
			} else if((elemName == "Input Source") || (elemName == "Capture Source"))
				ensureSlBox("Capture" + index, rmixSliderBox::FOOTER, m_wIn)->addSrcSel(elem, numCh);
			else if(elemName == "Loopback Mixing")
				addMiscEntry(ensureMiscBox("Routing", m_lMix), elem, "Direct Monitoring" + index, numCh);
			else if(elemName.endsWith("Route"))
				addMiscEntry(ensureMiscBox("Routing", m_lMix), elem, elemName + index, numCh);
			else if(elemName == "Independent HP")
				addMiscEntry(ensureMiscBox("Routing", m_lMix), elem, "Independent Headphone" + index, numCh);

			// Anything else
			else
				addMiscEntry(ensureMiscBox("Miscellaneous", m_lMisc), elem, elemName + index, numCh);
		}
		elem= snd_hctl_elem_next(elem);
	}

	// do the formatting in slboxes
	QList<rmixSliderBox *> slBoxes;
	slBoxes= m_wOut->findChildren<rmixSliderBox *>();
	for(rmixSliderBox *box: slBoxes)
		box->cleanup();
	slBoxes= m_wIn->findChildren<rmixSliderBox *>();
	for(rmixSliderBox *box: slBoxes)
		box->cleanup();
	slBoxes= m_wInt->findChildren<rmixSliderBox *>();
	for(rmixSliderBox *box: slBoxes)
		box->cleanup();

	// show sw control warning
	if(lbNoteInt)
		m_lInt->addWidget(new QLabel("* Items marked with an asterisk may potentially be software controls."));

	// hide empty tabs
	if(!m_lOut->count())
		setTabVisible(0, 0);
	m_lOut->addStretch();
	if(!m_lIn->count())
		setTabVisible(1, 0);
	m_lIn->addStretch();
	if(!m_lInt->count())
		setTabVisible(2, 0);
	m_lInt->addStretch();
	if(!m_lMix->count())
		setTabVisible(3, 0);
	m_lMix->addStretch();
	if(!m_lDig->count())
		setTabVisible(4, 0);
	m_lDig->addStretch();
	if(m_lMisc->count() == 1 && !m_lChmap->count() && !m_lJacksIn->count() && !m_lJacksOut->count())
		setTabVisible(5, 0);
	m_lMisc->addStretch();

	// populate t5disp windows
	QList<t5Disp *> t5btns= m_wDig->findChildren<t5Disp *>();
	for(t5Disp *w: t5btns)
		w->activat();

	connect(m_timer, SIGNAL(timeout()), m_mixer, SLOT(updat()));
	m_timer->start(100);
}

rmixSliderBox *ParamsWidget::ensureSlBox(QString name, rmixSliderBox::ctrlType_t ctrlType, QWidget *parent) {
	rmixSliderBox *sb;
	sb= parent->findChild<rmixSliderBox *>(name);
	if(sb == nullptr)
	{
		sb= new rmixSliderBox(this, m_mixer, name);
		parent->layout()->addWidget(sb);
	}
	return sb;
}

QFormLayout *ParamsWidget::ensureMiscBox(QString name, QVBoxLayout *parentL) {
	QGroupBox *gb= findChild<QGroupBox *>(name);
	if(gb != nullptr)
		return qobject_cast<QFormLayout *>(gb->layout());
	else
	{
		gb= new QGroupBox(name);
		gb->setObjectName(name);
		QFormLayout *lBox= new QFormLayout(gb);
		parentL->addWidget(gb);
		return lBox;
	}
}

void ParamsWidget::addMiscJack(QFormLayout *box, snd_hctl_elem_t *elem, QString name, QString index, ushort numCh) {
	QHBoxLayout *lRow= new QHBoxLayout();
	for(ushort ch= 0; ch < numCh; ch++)
		lRow->addWidget(new rmixCheckBox(elem, ch, 1, nullptr));
	name= name.first(name.lastIndexOf(' '));
	if(name.endsWith(" Phantom"))
		box->addRow(name.first(name.lastIndexOf(' ')) + index + " (virtual):", lRow);
	else
		box->addRow(name + index + ':', lRow);
}

void ParamsWidget::addMiscEntry(QFormLayout *lBox, snd_hctl_elem_t *elem, QString name, ushort numCh) {
	QHBoxLayout *lRow= new QHBoxLayout();
	snd_ctl_elem_type_t type= snd_ctl_elem_info_get_type(m_info);

	if(type == 5)
		lRow->addWidget(new t5Disp(elem, name, m_mixer));

	else if(type == 1) // bool
	{
		rmixCheckBox *prev= nullptr;
		rmixCheckBox *w;
		if(snd_ctl_elem_info_is_writable(m_info))
		{
			for(ushort j= 0; j < numCh; j++)
			{
				w= new rmixCheckBox(elem, j, 0, prev);
				lRow->addWidget(w);
				prev= w;
			}
		} else
		{
			for(ushort j= 0; j < numCh; j++)
			{
				w= new rmixCheckBox(elem, j, 1, prev);
				lRow->addWidget(w);
				prev= w;
			}
		}
	}

	else if(type == 3) // enum
	{
		rmixEnumBox *prev= nullptr;
		for(ushort j= 0; j < numCh; j++)
		{
			rmixEnumBox *w= new rmixEnumBox(elem, j, prev);
			if(!snd_ctl_elem_info_is_writable(m_info))
				w->setDisabled(1);
			lRow->addWidget(w);
			prev= w;
		}
	}

	else // 2,4,6 (simply number)
	{
		rmixNumSpin *prev= nullptr;
		for(ushort j= 0; j < numCh; j++)
		{
			rmixNumSpin *w= new rmixNumSpin(elem, j, snd_ctl_elem_info_is_writable(m_info), prev);
			lRow->addWidget(w);
			prev= w;
		}
	}
	lRow->addStretch();
	lBox->addRow(name + ':', lRow);
}

bool ParamsWidget::isInput(QString elemName) {
	return elemName.contains("Mic") || (elemName.contains("Line") && !elemName.contains("Out")) || elemName.contains("Aux") || elemName.contains("CD") || elemName.endsWith("In") || elemName == "Beep";
}

bool ParamsWidget::isInternal(QString elemName) {
	return elemName.contains("Synth") || elemName == "Phone";
}
