/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.utils;

import ancestris.modules.releve.model.DataManager;
import ancestris.modules.releve.utils.Java2sAutoComboBox;
import genj.util.ChangeSupport;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class Java2sAutoTextField
extends JTextField {
    private List<String> dataList;
    private boolean isCaseSensitive = false;
    private boolean isStrict = false;
    private boolean isUpperAllChar = false;
    private boolean isUpperAllFirstChar = false;
    private boolean isUpperFirstChar = false;
    private Java2sAutoComboBox autoComboBox = null;
    private ChangeSupport changeSupport = new ChangeSupport(this){

        public void fireChangeEvent() {
            super.fireChangeEvent();
        }
    };

    public Java2sAutoTextField(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("list can not be null");
        }
        this.dataList = list;
        this.init();
    }

    Java2sAutoTextField(List<String> list, Java2sAutoComboBox b) {
        if (list == null) {
            throw new IllegalArgumentException("list can not be null");
        }
        this.dataList = list;
        this.autoComboBox = b;
        this.init();
    }

    private void init() {
        this.setDocument(new AutoDocument());
        if (this.isStrict && this.dataList.size() > 0) {
            this.setText(this.dataList.get(0));
        }
    }

    private String getMatch(String s) {
        for (int i = 0; i < this.dataList.size(); ++i) {
            String s1 = this.dataList.get(i);
            if (s1 == null) continue;
            if (!this.isCaseSensitive && s1.toLowerCase().startsWith(s.toLowerCase())) {
                return s1;
            }
            if (!this.isCaseSensitive || !s1.startsWith(s)) continue;
            return s1;
        }
        return null;
    }

    @Override
    public void replaceSelection(String s) {
        AutoDocument _lb = (AutoDocument)this.getDocument();
        if (_lb != null) {
            try {
                int i = Math.min(this.getCaret().getDot(), this.getCaret().getMark());
                int j = Math.max(this.getCaret().getDot(), this.getCaret().getMark());
                _lb.replace(i, j - i, s, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean flag) {
        this.isCaseSensitive = flag;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public void setStrict(boolean flag) {
        this.isStrict = flag;
    }

    public void setUpperAllChar(boolean flag) {
        this.isUpperAllChar = flag;
    }

    public void setUpperAllFirstChar(boolean flag) {
        this.isUpperAllFirstChar = flag;
    }

    public void setUpperFirstChar(boolean flag) {
        this.isUpperFirstChar = flag;
    }

    public List<String> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("list can not be null");
        }
        this.dataList = list;
    }

    @Override
    public void setText(String text) {
        ((AutoDocument)this.getDocument()).setText(text);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        if ((e.getKeyCode() == 40 || e.getKeyCode() == 38) && (e.getModifiersEx() & 0x200) != 0) {
            if (this.autoComboBox != null) {
                this.autoComboBox.getParent().dispatchEvent(e);
            } else {
                this.getParent().dispatchEvent(e);
            }
            return;
        }
        super.processKeyEvent(e);
    }

    class AutoDocument
    extends PlainDocument {
        AutoDocument() {
        }

        @Override
        public void replace(int i, int j, String s, AttributeSet attributeset) throws BadLocationException {
            super.remove(i, j);
            this.insertString(i, s, attributeset);
            Java2sAutoTextField.this.changeSupport.fireChangeEvent();
        }

        @Override
        public void insertString(int i, String s, AttributeSet attributeset) throws BadLocationException {
            int j;
            if (s == null || "".equals(s)) {
                return;
            }
            String s1 = this.getText(0, i);
            if (Java2sAutoTextField.this.isUpperAllChar) {
                s = s.toUpperCase(Java2sAutoTextField.this.getLocale());
            } else if (Java2sAutoTextField.this.isUpperAllFirstChar) {
                s3 = new StringBuilder();
                for (j = 0; j < s.length(); ++j) {
                    if (i + j == 0 || i > 0 && j == 0 && (s1.charAt(i - 1) == ' ' || s1.charAt(i - 1) == '-' || s1.charAt(i - 1) == ',') || j > 0 && (s.charAt(j - 1) == ' ' || s.charAt(j - 1) == '-' || s.charAt(j - 1) == ',')) {
                        s3.append(s.substring(j, j + 1).toUpperCase(Java2sAutoTextField.this.getLocale()));
                        continue;
                    }
                    s3.append(s.substring(j, j + 1).toLowerCase(Java2sAutoTextField.this.getLocale()));
                }
                s = s3.toString();
            } else if (Java2sAutoTextField.this.isUpperFirstChar) {
                s3 = new StringBuilder();
                for (j = 0; j < s.length(); ++j) {
                    if (i + j == 0) {
                        s3.append(s.substring(j, j + 1).toUpperCase(Java2sAutoTextField.this.getLocale()));
                        continue;
                    }
                    s3.append(s.substring(j, j + 1));
                }
                s = s3.toString();
            }
            String s2 = Java2sAutoTextField.this.getMatch(s1 + s);
            j = i + s.length() - 1;
            if (Java2sAutoTextField.this.isStrict && s2 == null) {
                s2 = Java2sAutoTextField.this.getMatch(s1);
                --j;
            } else if (!Java2sAutoTextField.this.isStrict && s2 == null) {
                super.insertString(i, s, attributeset);
                return;
            }
            if (DataManager.getAutoselection() && Java2sAutoTextField.this.autoComboBox != null && s2 != null) {
                Java2sAutoTextField.this.autoComboBox.setSelectedValue(s2);
            }
            super.remove(0, this.getLength());
            super.insertString(0, s2, attributeset);
            Java2sAutoTextField.this.setSelectionStart(j + 1);
            Java2sAutoTextField.this.setSelectionEnd(this.getLength());
            Java2sAutoTextField.this.changeSupport.fireChangeEvent();
        }

        @Override
        public void remove(int i, int j) throws BadLocationException {
            if (!DataManager.getAutoselection()) {
                super.remove(i, j);
                Java2sAutoTextField.this.changeSupport.fireChangeEvent();
                return;
            }
            int k = Java2sAutoTextField.this.getSelectionStart();
            if (k > 0) {
                --k;
            }
            String s = Java2sAutoTextField.this.getMatch(this.getText(0, k));
            if (i <= 1 && k == 0) {
                super.remove(0, this.getLength());
                s = "";
            } else if (!Java2sAutoTextField.this.isStrict && s == null) {
                super.remove(i, j);
            } else {
                super.remove(0, this.getLength());
                super.insertString(0, s, null);
            }
            if (Java2sAutoTextField.this.autoComboBox != null && s != null) {
                Java2sAutoTextField.this.autoComboBox.setSelectedValue(s);
            }
            try {
                Java2sAutoTextField.this.setSelectionStart(k);
                Java2sAutoTextField.this.setSelectionEnd(this.getLength());
                Java2sAutoTextField.this.changeSupport.fireChangeEvent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setText(String s) {
            try {
                String oldValue = super.getText(0, this.getLength());
                if (!oldValue.equals(s)) {
                    super.remove(0, this.getLength());
                    super.insertString(0, s, null);
                    Java2sAutoTextField.this.changeSupport.fireChangeEvent();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

