/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.imageBrowser;

import ancestris.modules.releve.imageBrowser.BrowserPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class BrowserFrame
extends JFrame {
    private static BrowserFrame currentBrowserFrame = null;
    private BrowserPanel browserPanel2;

    public static void showEventImage(String filepath, String city, String notary, String cote, String page) {
        if (currentBrowserFrame == null) {
            currentBrowserFrame = new BrowserFrame();
            currentBrowserFrame.setVisible(true);
        } else {
            currentBrowserFrame.toFront();
            currentBrowserFrame.setVisible(true);
            if (currentBrowserFrame.getState() == 1) {
                currentBrowserFrame.setState(0);
            }
        }
        StringBuilder sb = new StringBuilder();
        if (!city.isBlank()) {
            sb.append(city);
            sb.append("-");
        }
        if (!notary.isBlank()) {
            sb.append(notary);
            sb.append("-");
        }
        if (!cote.isBlank()) {
            sb.append(cote);
            sb.append("-");
        }
        sb.append(page);
        currentBrowserFrame.setTitle(NbBundle.getMessage(BrowserFrame.class, (String)"Browserframe.imagefile", (Object)sb.toString()));
        BrowserFrame.currentBrowserFrame.browserPanel2.showImage(filepath, sb.toString(), city, notary, cote, page);
    }

    private BrowserFrame() {
        this.initComponents();
        ImageIcon icon = new ImageIcon(BrowserFrame.class.getResource("/ancestris/modules/releve/images/Releve.png"));
        this.setIconImage(icon.getImage());
        String size = NbPreferences.forModule(BrowserFrame.class).get("BrowserFrameSize", "300,450,0,0");
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        String[] dimensions = size.split(",");
        Rectangle browserFrameBounds = new Rectangle();
        if (dimensions.length >= 4) {
            int width = Integer.parseInt(dimensions[0]);
            int height = Integer.parseInt(dimensions[1]);
            int x = Integer.parseInt(dimensions[2]);
            int y = Integer.parseInt(dimensions[3]);
            if (width < 100) {
                width = 100;
            }
            if (height < 100) {
                height = 100;
            }
            if (x < 10 || x > screen.width - 10) {
                x = screen.width / 2 - width / 2;
            }
            if (y < 10 || y > screen.height - 10) {
                y = screen.height / 2 - height / 2;
            }
            browserFrameBounds.setBounds(x, y, width, height);
        } else {
            browserFrameBounds.setBounds(screen.width / 2 - 100, screen.height / 2 - 100, 300, 450);
        }
        this.setBounds(browserFrameBounds);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BrowserFrame.this.componentClosed();
            }
        });
    }

    public void closeComponent() {
        this.componentClosed();
        this.dispose();
    }

    public void componentClosed() {
        if (this.getExtendedState() != 0) {
            this.setExtendedState(0);
        }
        String size = String.valueOf(this.getWidth()) + "," + String.valueOf(this.getHeight()) + "," + String.valueOf(this.getLocation().x) + "," + String.valueOf(this.getLocation().y);
        NbPreferences.forModule(BrowserFrame.class).put("BrowserFrameSize", size);
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void setTitle(String fileName) {
        super.setTitle(fileName);
    }

    private void initComponents() {
        this.browserPanel2 = new BrowserPanel();
        this.setDefaultCloseOperation(0);
        this.getContentPane().add((Component)this.browserPanel2, "Center");
        this.pack();
    }
}

