/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.editor;

import ancestris.modules.releve.editor.Bean;
import ancestris.modules.releve.model.Field;
import ancestris.modules.releve.model.FieldAge;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.MaskFormatter;
import org.openide.util.NbBundle;

public class BeanAge
extends Bean {
    static final String yearLabel = NbBundle.getMessage(BeanAge.class, (String)"BeanAge.YearInitial");
    static final String monthLabel = NbBundle.getMessage(BeanAge.class, (String)"BeanAge.MonthInitial");
    static final String dayLabel = NbBundle.getMessage(BeanAge.class, (String)"BeanAge.DayInitial");
    static final String valueFormat = String.format("%%3s%s  %%2s%s  %%2s%s", yearLabel, monthLabel, dayLabel);
    static final String maskFormat = String.format("***%s  **%s  **%s", yearLabel, monthLabel, dayLabel);
    static final Pattern pattern = Pattern.compile(String.format("^([0-9\\p{javaWhitespace}]{3})%s  ([0-9\\p{javaWhitespace}]{2})%s  ([0-9\\p{javaWhitespace}]{2})%s?$", yearLabel, monthLabel, dayLabel));
    private final JFormattedTextField tfield;

    public BeanAge() {
        MaskFormatter mask = null;
        try {
            mask = new MaskFormatter(maskFormat);
            mask.setPlaceholderCharacter(' ');
            mask.setValidCharacters("0123456789 ");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.tfield = new JFormattedTextField(mask);
        this.tfield.getDocument().addDocumentListener((DocumentListener)this.changeSupport);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tfield, "Center");
        this.defaultFocus = this.tfield;
    }

    @Override
    public void setFieldImpl() {
        FieldAge property = (FieldAge)this.getField();
        if (property == null) {
            this.tfield.setText("");
        } else {
            String txt = String.format(valueFormat, property.getDelta().getYears() == 0 ? "" : String.valueOf(property.getDelta().getYears()), property.getDelta().getMonths() == 0 ? "" : String.valueOf(property.getDelta().getMonths()), property.getDelta().getDays() == 0 ? "" : String.valueOf(property.getDelta().getDays()));
            this.tfield.setText(txt);
        }
        this.tfield.setCaretPosition(0);
        this.changeSupport.setChanged(false);
    }

    @Override
    protected void commitImpl() {
        Matcher matcher = pattern.matcher(this.tfield.getText());
        if (matcher.matches()) {
            String deltaValue = (String)(matcher.group(1).trim().isEmpty() ? "" : matcher.group(1).trim() + "y ") + (String)(matcher.group(2).trim().isEmpty() ? "" : matcher.group(2).trim() + "m ") + (String)(matcher.group(3).trim().isEmpty() ? "" : matcher.group(3).trim() + "d");
            this.setFieldValue(deltaValue);
        }
    }

    @Override
    protected void replaceValueImpl(Field field) {
        FieldAge fieldAge = (FieldAge)field;
        if (fieldAge != null && fieldAge instanceof FieldAge) {
            FieldAge property = (FieldAge)field;
            String txt = String.format(valueFormat, property.getDelta().getYears() == 0 ? "" : String.valueOf(property.getDelta().getYears()), property.getDelta().getMonths() == 0 ? "" : String.valueOf(property.getDelta().getMonths()), property.getDelta().getDays() == 0 ? "" : String.valueOf(property.getDelta().getDays()));
            this.tfield.setText(txt);
        } else {
            String txt = String.format(valueFormat, "   ", "  ", "  ");
            this.tfield.setText(txt);
        }
    }
}

