/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WebStatsFrequent
extends WebSection {
    private String here2indiDir = "";
    private String here2cityDir = "";
    private String here2dayDir = "";
    private static final int TYPE_LASTNAME = 0;
    private static final int TYPE_LOCATION = 1;
    private static final int TYPE_DATE = 2;
    private List<Info> lastnamesList = new ArrayList<Info>();
    private List<Info> citiesList = new ArrayList<Info>();
    private List<Info> daysList = new ArrayList<Info>();
    private Comparator<Info> sortbyFrequency = new Comparator<Info>(){

        @Override
        public int compare(Info info1, Info info2) {
            if (info2.frequency == info1.frequency) {
                return WebStatsFrequent.this.sortLastnames.compare(info1.key, info2.key);
            }
            return info2.frequency - info1.frequency;
        }
    };

    public WebStatsFrequent(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        this.init(this.trs("TXT_StatsFrequent"), "stats", "stats_", this.formatFromSize(this.wh.getNbIndis()), 1, 0);
    }

    @Override
    public void create() {
        if (this.wb.sectionIndividuals != null) {
            this.namePage = this.wb.sectionIndividuals.getPagesMap();
            this.here2indiDir = this.buildLinkShort(this, this.wb.sectionIndividuals);
        }
        if (this.wb.sectionCitiesDetails != null) {
            this.cityPage = this.wb.sectionCitiesDetails.getPagesMap();
            this.here2cityDir = this.buildLinkShort(this, this.wb.sectionCitiesDetails);
        }
        if (this.wb.sectionDaysDetails != null) {
            this.dayPage = this.wb.sectionDaysDetails.getPagesMap();
            this.here2dayDir = this.buildLinkShort(this, this.wb.sectionDaysDetails);
        }
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + File.separator + this.sectionDir, true);
        this.exportData(dir);
    }

    private void exportData(File dir) {
        String fileStr = this.sectionPrefix + String.format(this.formatNbrs, 1) + this.sectionSuffix;
        File file = this.wh.getFileForName(dir, fileStr);
        try (PrintWriter out = this.wh.getWriter(file, this.UTF8);){
            if (out == null) {
                return;
            }
            this.computeFrequency(0);
            this.computeFrequency(1);
            this.computeFrequency(2);
            this.printOpenHTML(out, "TXT_StatsFrequent", this);
            this.printHomeLink(out, this);
            this.printHeader(out);
            this.printFrequency(out);
            this.printCloseHTML(out);
            this.wh.log.write(fileStr + this.trs("EXEC_DONE"));
        }
    }

    private void computeFrequency(int type) {
        Info iOccu;
        Iterator<String> itr;
        if (type == 0) {
            this.lastnamesList.clear();
            itr = this.wh.getLastNames("_", this.sortLastnames).iterator();
            while (itr.hasNext()) {
                iOccu = new Info();
                iOccu.key = itr.next();
                iOccu.frequency = this.wh.getLastNameCount(iOccu.key, "_");
                this.lastnamesList.add(iOccu);
            }
            Collections.sort(this.lastnamesList, this.sortbyFrequency);
        }
        if (type == 1) {
            this.citiesList.clear();
            itr = this.wh.getCities(this.wh.gedcom).iterator();
            while (itr.hasNext()) {
                iOccu = new Info();
                String tmpStr = itr.next();
                iOccu.key = this.wh.getCityDisplayName(tmpStr);
                iOccu.frequency = this.wh.getCitiesCount(tmpStr);
                this.citiesList.add(iOccu);
            }
            Collections.sort(this.citiesList, this.sortbyFrequency);
        }
        if (type == 2) {
            this.daysList.clear();
            itr = this.wh.getDays(this.wh.gedcom).iterator();
            while (itr.hasNext()) {
                iOccu = new Info();
                iOccu.key = itr.next();
                iOccu.frequency = this.wh.getDaysCount(iOccu.key);
                this.daysList.add(iOccu);
            }
            Collections.sort(this.daysList, this.sortbyFrequency);
        }
    }

    private void printHeader(PrintWriter out) {
        out.println("<div class=\"contreport\">");
        out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.htmlText(this.trs("frequency_description")) + "</span></p>");
        out.println("<p class=\"description\">" + this.htmlText(this.trs("frequency_info")) + "</p>");
        out.println("<div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
    }

    private void printFrequency(PrintWriter out) {
        out.println("<div class=\"contreport2\">");
        out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.htmlText(this.trs("frequency_table")) + "</span></p>");
        out.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"5\" class=\"column1\"><thead><tr>");
        out.println("<th>" + this.htmlText(this.trs("frequency_header_rank")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("frequency_header_lastname")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("frequency_header_frequency")) + "</th>");
        out.println("<th>&nbsp;</th>");
        out.println("<th>" + this.htmlText(this.trs("frequency_header_city")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("frequency_header_frequency")) + "</th>");
        out.println("<th>&nbsp;</th>");
        out.println("<th>" + this.htmlText(this.trs("frequency_header_day")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("frequency_header_frequency")) + "</th>");
        out.println("</tr></thead>");
        out.println("<tbody>");
        int l = Math.max(this.lastnamesList.size(), Math.max(this.citiesList.size(), this.daysList.size()));
        for (int i = 0; i < l; ++i) {
            out.println("<tr>");
            out.println("<td>" + (i + 1) + "</td>");
            this.printRowElement(0, out, i, this.lastnamesList, this.here2indiDir, this.namePage);
            out.println("<td>&nbsp;</td>");
            this.printRowElement(1, out, i, this.citiesList, this.here2cityDir, this.cityPage);
            out.println("<td>&nbsp;</td>");
            this.printRowElement(2, out, i, this.daysList, this.here2dayDir, this.dayPage);
            out.println("</tr>");
        }
        out.println("</tbody></table>");
        out.println("<div class=\"spacer\">&nbsp;</div></div>");
    }

    private void printRowElement(int type, PrintWriter out, int i, List<Info> list, String here2Dir, Map<String, String> pages) {
        if (i < list.size()) {
            Info info = list.get(i);
            Object text = null;
            Object anchor = null;
            String page = null;
            if (type == 2) {
                String month = this.trs(this.Months[Integer.valueOf(info.key.substring(0, 2)) - 1]);
                String day = info.key.substring(2, 4);
                text = day + "&nbsp;" + this.htmlText(month);
                anchor = this.htmlAnchorText(month) + day;
                page = here2Dir + pages.get(info.key);
            } else {
                text = this.htmlText(info.key);
                anchor = this.htmlAnchorText(info.key);
                page = here2Dir + pages.get(anchor);
            }
            out.println("<td><a href=\"" + page + "#" + (String)anchor + "\">" + (String)text + "</a></td>");
            out.println("<td>" + this.htmlText(Integer.toString(info.frequency)) + "</td>");
        } else {
            out.println("<td>&nbsp;</td>");
            out.println("<td>&nbsp;</td>");
        }
    }

    private class Info {
        String key;
        int frequency;

        private Info() {
        }
    }
}

