/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.api.place.Place;
import ancestris.api.place.PlaceFactory;
import ancestris.core.pluginservice.PluginInterface;
import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import org.openide.util.Lookup;

public class WebMap
extends WebSection {
    private Class<?> clazz = null;
    private int geoProblems = 0;
    private final Map<String, CityFlash> citiesFlash = new TreeMap<String, CityFlash>();
    private Set<Indi> ancestors = null;
    private Set<Indi> cousins = null;

    public WebMap(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        this.init(this.trs("TXT_Map"), "map", "map", "", 1, 0);
        if (!this.isModuleGeo()) {
            this.toBeGenerated = false;
            this.wh.log.write(this.trs("LOG_Geo_module_Not_Found"));
        }
    }

    private boolean isModuleGeo() {
        boolean found = false;
        for (PluginInterface sInterface : Lookup.getDefault().lookupAll(PluginInterface.class)) {
            try {
                if (!sInterface.getPluginName().equals("ancestris.modules.geo")) continue;
                found = true;
                this.clazz = sInterface.getClass();
            }
            catch (Throwable throwable) {}
        }
        return found;
    }

    @Override
    public void create() {
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + (String)(this.sectionDir.length() == 0 ? "" : File.separator + this.sectionDir), true);
        if (this.wb.sectionCitiesDetails != null) {
            this.cityPage = this.wb.sectionCitiesDetails.getPagesMap();
            this.prefixPersonDetailsDir = this.buildLinkShort(this, this.wb.sectionCitiesDetails);
        }
        this.exportPage(dir);
        this.exportXMLData(dir, this.wh.getIndiDeCujus(this.wp.param_decujus));
    }

    private void exportPage(File dir) {
        String fileStr = this.sectionPrefix + String.format(this.formatNbrs, 1) + this.sectionSuffix;
        File file = this.wh.getFileForName(dir, fileStr);
        try (PrintWriter out = this.wh.getWriter(file, this.UTF8);){
            if (out == null) {
                return;
            }
            this.printOpenHTMLHead(out, "TXT_Map", this, true);
            out.println("<script src=\"./map-markers.js\" ></script>");
            out.println("<script src=\"./map.js\" ></script>");
            this.exportFilterFile("js/map.js", file.getParent() + "/map.js");
            out.println("<div class=\"title\"><a id=\"top\">&nbsp;</a>" + this.htmlText(this.trs("TXT_Map")) + "</div>");
            this.printHomeLink(out, this);
            out.println("<div id=\"map\" class=\"map\" style=\"height: 600px\"></div>");
            this.printCloseHTML(out);
            this.wh.log.write(fileStr + this.trs("EXEC_DONE"));
        }
    }

    private void exportFilterFile(String input, String output) {
        File outputFile = new File(output);
        try (PrintWriter out = this.wh.getWriter(outputFile, this.UTF8);){
            if (out == null) {
                return;
            }
            try {
                String str = this.wh.readStream(input);
                out.println(this.filter(str));
            }
            catch (IOException e) {
                this.wb.log.write(this.wb.log.ERROR, "exportMap - " + e.getMessage());
            }
        }
    }

    private String filter(String inputStr) {
        String text = inputStr.replaceAll("map_detailed_events", this.trs("map_detailed_events"));
        return text;
    }

    private void exportXMLData(File dir, Indi indi) {
        String fileStr = "map-markers.js";
        File file = this.wh.getFileForName(dir, fileStr);
        try (PrintWriter out = this.wh.getWriter(file, this.UTF8);){
            if (out == null) {
                return;
            }
            this.ancestors = this.wh.getAncestors(indi);
            this.wh.log.write("Number of ascendants: " + this.ancestors.size());
            this.cousins = this.wh.getCousins(indi);
            this.wh.log.write("Number of cousins: " + this.cousins.size());
            this.calculateCitiesFlash();
            this.exportCitiesFlash(out);
            this.wh.log.write(fileStr + this.trs("EXEC_DONE"));
        }
    }

    private void calculateCitiesFlash() {
        CityFlash cityFlash;
        this.geoProblems = 0;
        for (String city : this.wh.getCities(this.wh.gedcom)) {
            List<Property> listProps = this.wh.getCitiesProps(city);
            for (Property prop : listProps) {
                if (prop == null || prop.getValue().length() == 0) continue;
                String fullname = this.wb.sectionCitiesDetails.getFullname(prop);
                CityFlash cityFlash2 = this.citiesFlash.get(fullname);
                if (cityFlash2 == null) {
                    cityFlash2 = this.createCityFlashRecord(fullname, prop);
                }
                this.addDetails2cityFlashRecord(cityFlash2, prop);
                this.citiesFlash.put(fullname, cityFlash2);
            }
        }
        if (this.geoProblems != 0) {
            this.wh.log.write(this.trs("LOG_LocationsUnfound", this.geoProblems));
        }
        int maxVolume = 0;
        for (String city : this.citiesFlash.keySet()) {
            Integer total;
            cityFlash = this.citiesFlash.get(city);
            if (cityFlash == null || (total = Integer.valueOf(cityFlash.nbBirths + cityFlash.nbMarriages + cityFlash.nbDeaths + cityFlash.nbOther)) <= maxVolume) continue;
            maxVolume = total;
        }
        for (String city : this.citiesFlash.keySet()) {
            cityFlash = this.citiesFlash.get(city);
            if (cityFlash == null) continue;
            this.calculateMeasures(cityFlash, maxVolume);
        }
        this.calculateDensity();
    }

    private CityFlash createCityFlashRecord(String fullname, Property prop) {
        CityFlash cityFlash = new CityFlash();
        cityFlash.fullName = fullname;
        cityFlash.city = this.wb.sectionCitiesDetails.getCity(prop);
        cityFlash.country = this.wb.sectionCitiesDetails.getCountry(prop);
        cityFlash.linkToPage = this.wb.sectionCitiesDetails.getPagesMap().get(this.htmlAnchorText(cityFlash.city));
        cityFlash.linkAnchor = this.htmlAnchorText(cityFlash.fullName);
        if (!this.findLocation(cityFlash, prop)) {
            ++this.geoProblems;
        }
        return cityFlash;
    }

    private boolean findLocation(CityFlash cf, Property prop) {
        cf.lat = 45.0;
        cf.lng = -4.0;
        if (this.clazz == null || !(prop instanceof PropertyPlace)) {
            return false;
        }
        PropertyPlace pPlace = (PropertyPlace)prop;
        if (pPlace.getLongitude(true) != null && pPlace.getLatitude(true) != null) {
            cf.lat = pPlace.getLatitude(true).getDoubleValue();
            cf.lng = pPlace.getLongitude(true).getDoubleValue();
            return true;
        }
        Place place = PlaceFactory.getLocalPlace((PropertyPlace)pPlace);
        if (place == null) {
            return false;
        }
        cf.lat = place.getLatitude();
        cf.lng = place.getLongitude();
        return true;
    }

    private void addDetails2cityFlashRecord(CityFlash cityFlash, Property prop) {
        Entity ent = prop.getEntity();
        if (ent instanceof Indi) {
            this.addIndividual(cityFlash, (Indi)ent);
        }
        if (ent instanceof Fam) {
            this.addIndividual(cityFlash, ((Fam)ent).getHusband());
            this.addIndividual(cityFlash, ((Fam)ent).getWife());
        }
        Property parent = prop.getParent();
        Property event = null;
        if (parent != null) {
            event = prop instanceof PropertyPlace ? parent : parent.getParent();
        }
        if (event != null) {
            this.addEvent(cityFlash, event.getTag());
        }
        this.addDate(cityFlash, this.wb.sectionCitiesDetails.getDate(prop));
    }

    private void addIndividual(CityFlash cityFlash, Indi indi) {
        if (this.ancestors.contains(indi)) {
            cityFlash.ascendants.add(indi);
        } else if (this.cousins.contains(indi)) {
            cityFlash.cousins.add(indi);
        } else {
            cityFlash.others.add(indi);
        }
        Integer counter = cityFlash.names.get(this.wh.getLastName(indi, "_"));
        if (counter == null) {
            counter = 0;
        }
        Integer n = counter;
        counter = counter + 1;
        cityFlash.names.put(this.wh.getLastName(indi, "_"), counter);
    }

    private void addEvent(CityFlash cityFlash, String tag) {
        if (tag.compareTo("BIRT") == 0) {
            ++cityFlash.nbBirths;
        } else if (tag.compareTo("MARR") == 0) {
            ++cityFlash.nbMarriages;
        } else if (tag.compareTo("DEAT") == 0) {
            ++cityFlash.nbDeaths;
        } else {
            ++cityFlash.nbOther;
        }
    }

    private void addDate(CityFlash cityFlash, PropertyDate pDate) {
        if (pDate == null) {
            return;
        }
        if (cityFlash.minDate == null) {
            cityFlash.minDate = pDate;
        }
        if (cityFlash.maxDate == null) {
            cityFlash.maxDate = pDate;
        }
        if (pDate.compareTo((Property)cityFlash.minDate) < 0) {
            cityFlash.minDate = pDate;
        }
        if (pDate.compareTo((Property)cityFlash.maxDate) > 0) {
            cityFlash.maxDate = pDate;
        }
    }

    private void calculateMeasures(CityFlash cityFlash, int maxVolume) {
        int total = cityFlash.nbBirths + cityFlash.nbMarriages + cityFlash.nbDeaths + cityFlash.nbOther;
        String string = total > maxVolume / 3 ? "h" : (cityFlash.size = total > maxVolume / 9 ? "m" : "l");
        cityFlash.ancestor = cityFlash.ascendants.size() > 0 ? "s" : (cityFlash.cousins.size() > 0 ? "c" : "o");
        String lastnames = this.getLastNames(cityFlash.names);
        cityFlash.type = "";
        if (cityFlash.nbBirths > 0) {
            cityFlash.type = cityFlash.type + "b";
        }
        if (cityFlash.nbMarriages > 0) {
            cityFlash.type = cityFlash.type + "m";
        }
        if (cityFlash.nbDeaths > 0) {
            cityFlash.type = cityFlash.type + "d";
        }
        if (cityFlash.type.length() == 0) {
            cityFlash.type = "x";
        }
        try {
            if (cityFlash.minDate != null) {
                cityFlash.min = cityFlash.minDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
            }
            if (cityFlash.maxDate != null) {
                cityFlash.max = cityFlash.maxDate.isRange() ? cityFlash.maxDate.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear() : cityFlash.maxDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
            }
        }
        catch (GedcomException e) {
            this.wb.log.write(this.wb.log.ERROR, "calculateMeasures - " + e.getMessage());
        }
        Object text = "";
        text = (String)text + this.trs("map_box_city") + " " + cityFlash.city + ", " + cityFlash.country + " (" + this.getCoordinateAsString(cityFlash.lng, cityFlash.lat) + ").;";
        text = (String)text + Integer.toString(cityFlash.ascendants.size() + cityFlash.cousins.size() + cityFlash.others.size()) + " " + this.trs("map_box_individual") + ": ";
        int cpt = 0;
        if (cityFlash.ascendants.size() > 0) {
            text = (String)text + Integer.toString(cityFlash.ascendants.size()) + " " + this.trs("map_box_ascendants");
        }
        cpt += cityFlash.ascendants.size();
        if (cityFlash.cousins.size() > 0) {
            text = (String)text + (cpt > 0 ? ", " : "") + Integer.toString(cityFlash.cousins.size()) + " " + this.trs("map_box_cousins");
        }
        cpt += cityFlash.cousins.size();
        if (cityFlash.others.size() > 0) {
            text = (String)text + (cpt > 0 ? ", " : "") + Integer.toString(cityFlash.others.size()) + " " + this.trs("map_box_others");
        }
        text = (String)text + ".;";
        if (lastnames.trim().length() != 0) {
            text = (String)text + this.trs("map_box_most") + ": " + lastnames + ".;";
        }
        text = (String)text + Integer.toString(cityFlash.nbBirths + cityFlash.nbMarriages + cityFlash.nbDeaths + cityFlash.nbOther) + " " + this.trs("map_box_events") + ": ";
        cpt = 0;
        if (cityFlash.nbBirths > 0) {
            text = (String)text + Integer.toString(cityFlash.nbBirths) + " " + this.trs("map_box_births");
        }
        cpt += cityFlash.nbBirths;
        if (cityFlash.nbMarriages > 0) {
            text = (String)text + (cpt > 0 ? ", " : "") + Integer.toString(cityFlash.nbMarriages) + " " + this.trs("map_box_marriages");
        }
        cpt += cityFlash.nbMarriages;
        if (cityFlash.nbDeaths > 0) {
            text = (String)text + (cpt > 0 ? ", " : "") + Integer.toString(cityFlash.nbDeaths) + " " + this.trs("map_box_deaths");
        }
        cpt += cityFlash.nbDeaths;
        if (cityFlash.nbOther > 0) {
            text = (String)text + (cpt > 0 ? ", " : "") + Integer.toString(cityFlash.nbOther) + " " + this.trs("map_box_others");
        }
        text = (String)text + ".;";
        if (cityFlash.minDate != null && cityFlash.minDate.compareTo((Property)cityFlash.maxDate) == 0) {
            text = (String)text + this.trs("map_box_occon") + " \"" + cityFlash.minDate.getDisplayValue() + "\".";
        } else if (cityFlash.minDate != null && cityFlash.maxDate != null) {
            text = (String)text + this.trs("map_box_occbet") + " \"" + cityFlash.minDate.getDisplayValue() + "\" " + this.trs("map_box_occand") + " \"" + cityFlash.maxDate.getDisplayValue() + "\".";
        }
        cityFlash.text = text;
    }

    private String getLastNames(Map<String, Integer> map) {
        Object output = "";
        for (int i = 0; i < 5; ++i) {
            Integer max = 0;
            String maxname = "";
            for (String name : map.keySet()) {
                Integer counter = map.get(name);
                if (counter <= max) continue;
                max = counter;
                maxname = name;
            }
            if (maxname.length() == 0) continue;
            output = (String)output + (i == 0 ? "" : ", ") + maxname;
            map.put(maxname, 0);
        }
        return output;
    }

    public String getCoordinateAsString(double lon, double lat) {
        if (Double.isNaN(lat) || Double.isNaN(lon)) {
            return "n/a";
        }
        char we = 'E';
        char ns = 'N';
        if (lat < 0.0) {
            lat = -lat;
            ns = 'S';
        }
        if (lon < 0.0) {
            lon = -lon;
            we = 'W';
        }
        DecimalFormat format = new DecimalFormat("0.0");
        return ns + format.format(lat) + " " + we + format.format(lon);
    }

    private void exportCitiesFlash(PrintWriter out) {
        out.println("function getMarkers() {");
        out.println("var obj = [");
        for (String city : this.citiesFlash.keySet()) {
            CityFlash cityFlash = this.citiesFlash.get(city);
            if (cityFlash == null || !this.wp.param_media_DispUnknownLoc.equals("1") && cityFlash.lng == -45.0 && cityFlash.lat == 30.0) continue;
            StringBuilder line = new StringBuilder();
            line.append("{\n ");
            line.append("\"x\": \"").append(cityFlash.lng).append("\", \n ");
            line.append("\"y\":\"").append(cityFlash.lat).append("\", \n ");
            line.append("\"s\":\"").append(cityFlash.size).append("\", \n ");
            line.append("\"a\":\"").append(cityFlash.ancestor).append("\", \n ");
            line.append("\"t\":\"").append(cityFlash.type).append("\", \n ");
            line.append("\"d\":\"").append(cityFlash.density).append("\", \n ");
            line.append("\"min\":\"").append(cityFlash.min).append("\", \n ");
            line.append("\"max\":\"").append(cityFlash.max).append("\", \n ");
            line.append("\"lkp\":\"").append(cityFlash.linkToPage).append("\", \n ");
            line.append("\"lki\":\"").append(cityFlash.linkAnchor).append("\", \n ");
            line.append("\"lko\":\"").append(this.htmlAnchorText(cityFlash.city)).append("\", \n ");
            line.append("\"cty\":\"").append(cityFlash.city.replaceAll("\"", Matcher.quoteReplacement("\\\""))).append("\", \n ");
            line.append("\"text\":\"").append(cityFlash.text.replaceAll("\"", Matcher.quoteReplacement("\\\""))).append("\" \n ");
            line.append("},\n");
            out.println(line);
        }
        out.println("];");
        out.println("return obj;\n}");
    }

    private void calculateDensity() {
        String[] city = new String[this.citiesFlash.keySet().size()];
        this.citiesFlash.keySet().toArray(city);
        int totalDistance = 0;
        int counter = 0;
        double[][] distance = new double[city.length][city.length];
        for (int i = 0; i < city.length; ++i) {
            if (city[i].compareTo("") == 0) continue;
            CityFlash cityFlashi = this.citiesFlash.get(city[i]);
            if (cityFlashi == null) {
                city[i] = "";
            }
            for (int j = 0; j < i; ++j) {
                if (city[j].compareTo("") == 0) continue;
                CityFlash cityFlashj = this.citiesFlash.get(city[j]);
                if (cityFlashj == null) {
                    city[j] = "";
                }
                distance[i][j] = Math.pow(cityFlashi.lng - cityFlashj.lng, 2.0) + Math.pow(cityFlashi.lat - cityFlashj.lat, 2.0);
                totalDistance = (int)((double)totalDistance + distance[i][j]);
                ++counter;
            }
        }
        double averageDistance = counter == 0 ? 0.0 : (double)(totalDistance / counter);
        this.checkDistances(Math.sqrt(averageDistance) / 60.0, "1", city, distance);
        this.checkDistances(Math.sqrt(averageDistance) / 30.0, "2", city, distance);
        int i = 0;
        for (String name : this.citiesFlash.keySet()) {
            CityFlash cityFlash = this.citiesFlash.get(name);
            cityFlash.density = city[i].compareTo("1") == 0 ? 1 : (city[i].compareTo("2") == 0 ? 2 : 3);
            ++i;
        }
    }

    private void checkDistances(double threshold, String value, String[] city, double[][] distance) {
        for (int i = 0; i < city.length; ++i) {
            if (city[i].length() == 1) continue;
            for (int j = 0; j < i; ++j) {
                if (city[j].length() == 1 || !(distance[i][j] < threshold)) continue;
                city[this.getBiggerCity((int)i, (int)j, (String)city[i], (String)city[j])] = value;
            }
        }
    }

    private int getBiggerCity(int i, int j, String cityI, String cityJ) {
        CityFlash cityFlashi = this.citiesFlash.get(cityI);
        CityFlash cityFlashj = this.citiesFlash.get(cityJ);
        if (cityFlashi == null) {
            return i;
        }
        if (cityFlashj == null) {
            return j;
        }
        if (cityFlashi.ascendants.size() > cityFlashj.ascendants.size()) {
            return j;
        }
        if (cityFlashi.ascendants.size() < cityFlashj.ascendants.size()) {
            return i;
        }
        if (cityFlashi.cousins.size() > cityFlashj.cousins.size()) {
            return j;
        }
        if (cityFlashi.cousins.size() < cityFlashj.cousins.size()) {
            return i;
        }
        int totali = cityFlashi.nbBirths + cityFlashi.nbMarriages + cityFlashi.nbDeaths + cityFlashi.nbOther;
        int totalj = cityFlashj.nbBirths + cityFlashj.nbMarriages + cityFlashj.nbDeaths + cityFlashj.nbOther;
        if (totali > totalj) {
            return j;
        }
        return i;
    }

    private class CityFlash {
        String fullName = "";
        String city = "";
        String country = "";
        String linkToPage = "";
        String linkAnchor = "";
        double lng = 0.0;
        double lat = 0.0;
        int density = 0;
        Set<Indi> ascendants = new HashSet<Indi>();
        Set<Indi> cousins = new HashSet<Indi>();
        Set<Indi> others = new HashSet<Indi>();
        Map<String, Integer> names = new TreeMap<String, Integer>();
        int nbBirths = 0;
        int nbMarriages = 0;
        int nbDeaths = 0;
        int nbOther = 0;
        PropertyDate minDate = null;
        PropertyDate maxDate = null;
        String size = "";
        String ancestor = "";
        String type = "";
        String text = "";
        int min = 0;
        int max = 0;

        private CityFlash() {
        }
    }
}

