/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.geo;

import java.util.Collections;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.html.BrwsrCtx;
import org.netbeans.html.context.spi.Contexts;
import org.netbeans.html.geo.impl.Accessor;
import org.netbeans.html.geo.impl.JsGLProvider;
import org.netbeans.html.geo.spi.GLProvider;

public final class Position {
    static final Logger LOG = Logger.getLogger(Position.class.getName());
    private final long timestamp;
    private final Coordinates coords;

    public Position(long timestamp, Coordinates coords) {
        this.timestamp = timestamp;
        this.coords = coords;
    }

    public Coordinates getCoords() {
        return this.coords;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static abstract class Coordinates {
        protected Coordinates() {
            if (!this.getClass().getName().equals("org.netbeans.html.geo.spi.CoordImpl")) {
                throw new IllegalStateException();
            }
        }

        public abstract double getLatitude();

        public abstract double getLongitude();

        public abstract double getAccuracy();

        public abstract Double getAltitude();

        public abstract Double getAltitudeAccuracy();

        public abstract Double getHeading();

        public abstract Double getSpeed();
    }

    public static abstract class Handle {
        private final boolean oneTime;
        private boolean enableHighAccuracy;
        private long timeout;
        private long maximumAge;
        volatile JsH<?> handle;

        protected Handle(boolean oneTime) {
            this.oneTime = oneTime;
        }

        protected abstract void onLocation(Position var1) throws Throwable;

        protected abstract void onError(Exception var1) throws Throwable;

        public final boolean isSupported() {
            JsH<?> p = this.seekProviders(null, null);
            if (p != null) {
                p.stop();
                return true;
            }
            return false;
        }

        public final void setHighAccuracy(boolean enable) {
            this.enableHighAccuracy = enable;
        }

        public final void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public final void setMaximumAge(long age) {
            this.maximumAge = age;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void start() {
            if (this.handle != null) {
                return;
            }
            Exception[] problem = new Exception[]{null};
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            JsH<?> h = this.seekProviders(sb, problem);
            sb.append("\n]");
            try {
                if (problem[0] != null) {
                    this.onError(problem[0]);
                    return;
                }
                if (h == null) {
                    this.onError(new IllegalStateException("geolocation API not supported. Among providers: " + sb));
                }
                Handle handle = this;
                synchronized (handle) {
                    if (this.handle != null) {
                        this.onError(new IllegalStateException("Parallel request"));
                    }
                    this.handle = h;
                }
            }
            catch (Throwable thr) {
                LOG.log(Level.INFO, "Problems delivering onError report", thr);
            }
        }

        private JsH<?> seekProviders(StringBuilder sb, Exception[] problem) {
            BrwsrCtx ctx = BrwsrCtx.findDefault(this.getClass());
            JsH<?> h = this.seekProviders((GLProvider)Contexts.find((BrwsrCtx)ctx, GLProvider.class), null, sb, problem);
            if (h == null) {
                h = this.seekProviders(null, ServiceLoader.load(GLProvider.class), sb, problem);
            }
            if (h == null) {
                h = this.seekProviders(new JsGLProvider(), null, sb, problem);
            }
            return h;
        }

        private JsH<?> seekProviders(GLProvider single, Iterable<GLProvider> set, StringBuilder sb, Exception[] problem) {
            if (set == null) {
                if (single == null) {
                    return null;
                }
                set = Collections.singleton(single);
            }
            JsH h = null;
            for (GLProvider p : set) {
                block7: {
                    if (sb != null) {
                        if (sb.length() > 1) {
                            sb.append(',');
                        }
                        sb.append("\n  ").append(p.getClass().getName());
                    }
                    try {
                        h = this.createHandle(p);
                    }
                    catch (Exception ex) {
                        LOG.log(Level.INFO, "Problems when starting " + p.getClass().getName(), ex);
                        if (problem == null || problem[0] != null) break block7;
                        problem[0] = ex;
                    }
                }
                if (h == null) continue;
                break;
            }
            return h;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void stop() {
            JsH<?> h;
            Handle handle = this;
            synchronized (handle) {
                h = this.handle;
                if (h == null) {
                    return;
                }
                this.handle = null;
            }
            h.stop();
        }

        private <Watch> JsH<Watch> createHandle(GLProvider<?, Watch> p) {
            JsH<Watch> temp = new JsH<Watch>(p);
            return ((JsH)temp).watch == null ? null : temp;
        }

        private final class JsH<Watch>
        extends Accessor {
            private final Watch watch;
            private final GLProvider<?, Watch> provider;

            public JsH(GLProvider<?, Watch> p) {
                super(true);
                this.watch = Accessor.SPI.start(p, this, Handle.this.oneTime, Handle.this.enableHighAccuracy, Handle.this.timeout, Handle.this.maximumAge);
                this.provider = p;
            }

            @Override
            public void onLocation(Position position) {
                if (Handle.this.handle != this) {
                    return;
                }
                if (Handle.this.oneTime) {
                    this.stop();
                }
                try {
                    Handle.this.onLocation(position);
                }
                catch (Throwable ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }

            @Override
            public void onError(Exception err) {
                if (Handle.this.handle != this) {
                    return;
                }
                if (Handle.this.oneTime) {
                    this.stop();
                }
                try {
                    Handle.this.onError(err);
                }
                catch (Throwable ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }

            protected final void stop() {
                Accessor.SPI.stop(this.provider, this.watch);
            }

            @Override
            public <Watch> Watch start(GLProvider<?, Watch> p, Accessor peer, boolean oneTime, boolean enableHighAccuracy, long timeout, long maximumAge) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <Watch> void stop(GLProvider<?, Watch> p, Watch w) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

