/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import ancestris.core.actions.AncestrisActionProvider;
import ancestris.view.ExplorerHelper;
import ancestris.view.PropertyProvider;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Entity;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintManager;
import genj.renderer.ChooseBlueprintAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JLabel;
import org.openide.nodes.Node;

public class EntityBean
extends PropertyBean
implements AncestrisActionProvider,
PropertyProvider {
    private PropertyBean.Preview preview = new PropertyBean.Preview();
    private JLabel changed = new JLabel();

    @Override
    public boolean isEditable() {
        return false;
    }

    public EntityBean() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.preview);
        this.add("South", this.changed);
        new ExplorerHelper((Component)this).setPopupAllowed(true);
        this.setToolTipText(RESOURCES.getString("entity.tooltip"));
    }

    @Override
    protected void commitImpl(Property property) {
    }

    @Override
    public void setPropertyImpl(Property prop) {
        Entity entity = (Entity)prop;
        this.preview.setEntity(entity);
        this.changed.setVisible(false);
        if (entity != null) {
            PropertyChange change = entity.getLastChange();
            if (change != null) {
                this.changed.setText(RESOURCES.getString("entity.change", new Object[]{change.getDateDisplayValue(), change.getTimeDisplayValue()}));
            }
            this.changed.setVisible(true);
        }
    }

    public List<Action> getActions(boolean hasFocus, Node[] nodes) {
        if (!hasFocus) {
            return new ArrayList<Action>();
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        String tag = this.property.getEntity().getTag();
        Blueprint bp = BlueprintManager.getInstance().getBlueprint(tag, REGISTRY.get("blueprint.entity" + tag, ""));
        actions.add((Action)new ChooseBlueprintAction(this.property.getEntity(), bp){

            protected void commit(Entity recipient, Blueprint blueprint) {
                PropertyBean.REGISTRY.put("blueprint.entity" + blueprint.getTag(), blueprint.getName());
                Entity entity = (Entity)EntityBean.this.property;
                EntityBean.this.preview.setEntity(entity);
            }
        });
        return actions;
    }

    public Property provideVisibleProperty(Point point) {
        return this.preview.getEntity();
    }
}

