/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.beans;

import genj.edit.beans.PropertyBean;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertySex;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;

public class ASexBean
extends PropertyBean {
    private JRadioButton female;
    private JRadioButton male;
    private JRadioButton unknown;
    private ButtonGroup group;
    private LC constraint = new LC().fillX().alignX("right").hideMode(2).flowY().gridGap("0", "0");
    private Dir direction = Dir.Y_AXIS;

    public ASexBean() {
        MigLayout yLayout = new MigLayout(this.constraint);
        this.group = new ButtonGroup();
        this.male = new JRadioButton();
        this.female = new JRadioButton();
        this.unknown = new JRadioButton();
        this.setLayout(new BoxLayout(this, 0));
        this.group.add(this.male);
        this.male.setText(NbBundle.getMessage(ASexBean.class, (String)"ASexBean.male.text"));
        this.add(this.male);
        this.group.add(this.female);
        this.female.setText(NbBundle.getMessage(ASexBean.class, (String)"ASexBean.female.text"));
        this.add(this.female);
        this.group.add(this.unknown);
        this.unknown.setText(NbBundle.getMessage(ASexBean.class, (String)"ASexBean.unknown.text"));
        this.add(this.unknown);
        this.setLayout((LayoutManager)yLayout);
        ActionHandler handler = new ActionHandler();
        this.male.addActionListener(handler);
        this.female.addActionListener(handler);
        this.unknown.addActionListener(handler);
    }

    @Override
    public String getTag() {
        return "SEX";
    }

    public Dir getDirection() {
        return this.direction;
    }

    public void setDirection(Dir direction) {
        this.direction = direction;
        switch (direction) {
            case X_AXIS: {
                this.constraint.flowX();
                break;
            }
            case Y_AXIS: {
                this.constraint.flowY();
            }
        }
        this.invalidate();
        this.repaint();
    }

    @Override
    protected void setPropertyImpl(Property prop) {
        this.defaultFocus = this.male;
        this.group.clearSelection();
        PropertySex sex = (PropertySex)prop;
        if (sex != null) {
            switch (sex.getSex()) {
                case 1: {
                    this.male.doClick();
                    this.defaultFocus = this.male;
                    break;
                }
                case 2: {
                    this.female.doClick();
                    this.defaultFocus = this.female;
                    break;
                }
                case 0: {
                    this.unknown.doClick();
                    this.defaultFocus = this.unknown;
                }
            }
        }
    }

    @Override
    protected void commitImpl(Property property) throws GedcomException {
        PropertySex sex = (PropertySex)property;
        sex.setSex(this.getSex());
    }

    private int getSex() {
        if (this.male.isSelected()) {
            return 1;
        }
        if (this.female.isSelected()) {
            return 2;
        }
        return 0;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public static enum Dir {
        X_AXIS,
        Y_AXIS;

    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ASexBean.this.changeSupport.fireChangeEvent();
        }
    }
}

