/*
 * Decompiled with CFR 0.152.
 */
package genj.search;

import genj.util.Registry;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SettingsPanel
extends JPanel {
    private static final int DEFAULT_MAX_HITS = 5000;
    private final Registry registry;
    private int max_hits;
    private boolean case_sensitive = false;
    private JCheckBox cbCaseSensitive;
    private JLabel maxHitsLabel;
    private JTextField maxHitsValue;

    public SettingsPanel(Registry registry) {
        this.registry = registry;
        this.max_hits = this.getMaxHits();
        this.case_sensitive = this.getCaseSensitive();
        this.initComponents();
        this.maxHitsValue.setText("" + this.max_hits);
        this.cbCaseSensitive.setSelected(this.case_sensitive);
    }

    private void initComponents() {
        this.maxHitsLabel = new JLabel();
        this.maxHitsValue = new JTextField();
        this.cbCaseSensitive = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.maxHitsLabel, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.maxHitsLabel.text"));
        this.maxHitsValue.setHorizontalAlignment(4);
        this.maxHitsValue.setText(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.maxHitsValue.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbCaseSensitive, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbCaseSensitive.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.maxHitsLabel).addGap(18, 18, 18).addComponent(this.maxHitsValue, -1, 131, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.cbCaseSensitive).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxHitsLabel).addComponent(this.maxHitsValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbCaseSensitive).addContainerGap(25, Short.MAX_VALUE)));
    }

    public int getMaxHits() {
        return this.registry.get("searchMaxHits", 5000);
    }

    public boolean getCaseSensitive() {
        return this.registry.get("searchCaseSensitive", false);
    }

    public void setSettings() {
        this.max_hits = Integer.valueOf(this.maxHitsValue.getText());
        this.registry.put("searchMaxHits", this.max_hits);
        this.case_sensitive = this.cbCaseSensitive.isSelected();
        this.registry.put("searchCaseSensitive", Boolean.valueOf(this.case_sensitive));
    }
}

