/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.spi;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.html.boot.impl.FnContext;
import org.netbeans.html.boot.spi.FallbackIdentity;

public abstract class Fn {
    private final Ref presenter;

    @Deprecated
    protected Fn() {
        this(null);
    }

    protected Fn(Presenter presenter) {
        this.presenter = Fn.ref(presenter);
    }

    public final boolean isValid() {
        return FnContext.currentPresenter(false) == this.presenter();
    }

    public static boolean isValid(Fn fnOrNull) {
        return fnOrNull != null && fnOrNull.isValid();
    }

    public static Fn define(Class<?> caller, String code, String ... names) {
        return Fn.define(caller, false, code, names);
    }

    public static Fn define(Class<?> caller, boolean keepParametersAlive, String code, String ... names) {
        Presenter p = FnContext.currentPresenter(false);
        if (p == null) {
            return null;
        }
        if (p instanceof KeepAlive) {
            boolean[] arr;
            if (!keepParametersAlive && names.length > 0) {
                arr = new boolean[names.length];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = false;
                }
            } else {
                arr = null;
            }
            return ((KeepAlive)((Object)p)).defineFn(code, names, arr);
        }
        return p.defineFn(code, names);
    }

    public static Fn preload(Fn fn, Class<?> caller, String resource) {
        if (fn == null) {
            return null;
        }
        return new Preload(fn.presenter(), fn, resource, caller);
    }

    public static Presenter activePresenter() {
        return FnContext.currentPresenter(false);
    }

    public static Closeable activate(Presenter p) {
        if (p == null) {
            throw new NullPointerException();
        }
        return FnContext.activate(p);
    }

    public static Ref<?> ref(Presenter p) {
        if (p == null) {
            return null;
        }
        if (p instanceof Ref) {
            Ref r = ((Ref)((Object)p)).reference();
            if (r == null) {
                throw new NullPointerException();
            }
            return r;
        }
        return new FallbackIdentity(p);
    }

    public abstract Object invoke(Object var1, Object ... var2) throws Exception;

    public void invokeLater(Object thiz, Object ... args) throws Exception {
        this.invoke(thiz, args);
    }

    protected final Presenter presenter() {
        return this.presenter == null ? null : (Presenter)this.presenter.presenter();
    }

    public static interface Ref<P extends Presenter> {
        public Ref<P> reference();

        public P presenter();

        public int hashCode();

        public boolean equals(Object var1);
    }

    public static interface Presenter {
        public Fn defineFn(String var1, String ... var2);

        public void displayPage(URL var1, Runnable var2);

        public void loadScript(Reader var1) throws Exception;
    }

    public static interface KeepAlive {
        public Fn defineFn(String var1, String[] var2, boolean[] var3);
    }

    private static class Preload
    extends Fn {
        private static Map<String, Set<Ref>> LOADED;
        private final Fn fn;
        private final String resource;
        private final Class<?> caller;

        Preload(Presenter presenter, Fn fn, String resource, Class<?> caller) {
            super(presenter);
            this.fn = fn;
            this.resource = resource;
            this.caller = caller;
        }

        @Override
        public Object invoke(Object thiz, Object ... args) throws Exception {
            this.loadResource();
            return this.fn.invoke(thiz, args);
        }

        @Override
        public void invokeLater(Object thiz, Object ... args) throws Exception {
            this.loadResource();
            this.fn.invokeLater(thiz, args);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadResource() throws Exception {
            Presenter realPresenter;
            Ref<?> id = ((Fn)this).presenter;
            if (id == null) {
                id = Preload.ref(FnContext.currentPresenter(false));
            }
            Presenter presenter = realPresenter = id == null ? null : (Presenter)id.presenter();
            if (realPresenter != null) {
                Set<Ref> there;
                if (LOADED == null) {
                    LOADED = new HashMap<String, Set<Ref>>();
                }
                if ((there = LOADED.get(this.resource)) == null) {
                    there = new HashSet<Ref>();
                    LOADED.put(this.resource, there);
                }
                if (there.add(id)) {
                    ClassLoader l = this.caller.getClassLoader();
                    InputStream is = l.getResourceAsStream(this.resource);
                    if (is == null && this.resource.startsWith("/")) {
                        is = l.getResourceAsStream(this.resource.substring(1));
                    }
                    if (is == null) {
                        throw new IOException("Cannot find " + this.resource + " in " + l);
                    }
                    try {
                        InputStreamReader r = new InputStreamReader(is, "UTF-8");
                        realPresenter.loadScript(r);
                    }
                    finally {
                        is.close();
                    }
                }
            }
        }
    }

    public static abstract class Promise {
        private static Reference<Presenter> last = new WeakReference<Object>(null);
        private static Fn[] lastFn;
        private final Presenter presenter;
        private final Object promise;
        private final Object success;
        private final Object failure;
        private boolean resolved;

        private static synchronized Fn[] wrapAndResolve() {
            Presenter ap = Fn.activePresenter();
            if (ap == null) {
                throw new NullPointerException("No presenter!");
            }
            if (lastFn != null && last.get() == ap) {
                return lastFn;
            }
            last = new WeakReference<Presenter>(ap);
            lastFn = new Fn[]{Fn.define(Promise.class, "var arr = [null, null, null];\narr[0] = new Promise(function (success, failure) {\n    arr[1] = success;\n    arr[2] = failure;\n});\nreturn arr;\n", new String[0]), Fn.define(Promise.class, "fn(value);", "fn", "value")};
            return lastFn;
        }

        protected Promise(Presenter p) {
            Object[] promiseSuccessFailure;
            this.presenter = p;
            try (Closeable ctx = Fn.activate(p);){
                promiseSuccessFailure = (Object[])Promise.wrapAndResolve()[0].invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
            this.promise = this.toJava(promiseSuccessFailure[0]);
            this.success = this.toJava(promiseSuccessFailure[1]);
            this.failure = this.toJava(promiseSuccessFailure[2]);
        }

        public final Object schedule() {
            try (Closeable ctx = Fn.activate(this.presenter);){
                FnContext.registerMicrotask(this::resolve);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            return this.promise;
        }

        protected abstract Object compute() throws Throwable;

        private void resolve() {
            if (!this.resolved) {
                try (Closeable ctx = Fn.activate(this.presenter);){
                    try {
                        Object result = this.compute();
                        Promise.wrapAndResolve()[1].invoke(null, this.success, result);
                        this.resolved = true;
                    }
                    catch (Throwable ex) {
                        try {
                            Promise.wrapAndResolve()[1].invoke(null, this.failure, ex);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.resolved = true;
                        }
                    }
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }

        private Object toJava(Object js) {
            Presenter presenter = Fn.activePresenter();
            if (presenter instanceof FromJavaScript) {
                FromJavaScript p = (FromJavaScript)((Object)presenter);
                return p.toJava(js);
            }
            return js;
        }
    }

    public static interface FromJavaScript {
        public Object toJava(Object var1);
    }

    public static interface ToJavaScript {
        public Object toJavaScript(Object var1);
    }
}

