/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swing;

import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.swing.Backend;
import org.graphstream.ui.swing.renderer.GraphBackgroundRenderer;
import org.graphstream.ui.swing.renderer.shape.Shape;
import org.graphstream.ui.swing.renderer.shape.swing.advancedShapes.AngleShape;
import org.graphstream.ui.swing.renderer.shape.swing.advancedShapes.BlobShape;
import org.graphstream.ui.swing.renderer.shape.swing.advancedShapes.CubicCurveShape;
import org.graphstream.ui.swing.renderer.shape.swing.advancedShapes.FreePlaneEdgeShape;
import org.graphstream.ui.swing.renderer.shape.swing.advancedShapes.HorizontalSquareEdgeShape;
import org.graphstream.ui.swing.renderer.shape.swing.advancedShapes.LSquareEdgeShape;
import org.graphstream.ui.swing.renderer.shape.swing.advancedShapes.PieChartShape;
import org.graphstream.ui.swing.renderer.shape.swing.arrowShapes.ArrowOnEdge;
import org.graphstream.ui.swing.renderer.shape.swing.arrowShapes.CircleOnEdge;
import org.graphstream.ui.swing.renderer.shape.swing.arrowShapes.DiamondOnEdge;
import org.graphstream.ui.swing.renderer.shape.swing.arrowShapes.ImageOnEdge;
import org.graphstream.ui.swing.renderer.shape.swing.baseShapes.LineShape;
import org.graphstream.ui.swing.renderer.shape.swing.baseShapes.PolylineEdgeShape;
import org.graphstream.ui.swing.renderer.shape.swing.basicShapes.CircleShape;
import org.graphstream.ui.swing.renderer.shape.swing.basicShapes.CrossShape;
import org.graphstream.ui.swing.renderer.shape.swing.basicShapes.DiamondShape;
import org.graphstream.ui.swing.renderer.shape.swing.basicShapes.FreePlaneNodeShape;
import org.graphstream.ui.swing.renderer.shape.swing.basicShapes.PolygonShape;
import org.graphstream.ui.swing.renderer.shape.swing.basicShapes.RoundedSquareShape;
import org.graphstream.ui.swing.renderer.shape.swing.basicShapes.SquareShape;
import org.graphstream.ui.swing.renderer.shape.swing.basicShapes.TriangleShape;
import org.graphstream.ui.swing.renderer.shape.swing.spriteShapes.OrientableSquareShape;
import org.graphstream.ui.swing.renderer.shape.swing.spriteShapes.SpriteArrowShape;
import org.graphstream.ui.swing.renderer.shape.swing.spriteShapes.SpriteFlowShape;

public class BackendJ2DDummy
implements Backend {
    private Container surface = null;
    private Stack<AffineTransform> matrixStack;
    private AffineTransform Tx = null;
    private AffineTransform xT = null;
    private Point2D dummyPoint = new Point2D.Double();

    public BackendJ2DDummy() {
        this.matrixStack = new Stack();
    }

    public void open(Container drawingSurface) {
        this.surface = drawingSurface;
    }

    public void close() {
        this.surface = null;
    }

    public void prepareNewFrame(Graphics2D g) {
        this.Tx = new AffineTransform();
        this.matrixStack.clear();
    }

    public Graphics2D graphics2D() {
        return null;
    }

    public Point3 transform(double x, double y, double z) {
        this.dummyPoint.setLocation(x, y);
        this.Tx.transform(this.dummyPoint, this.dummyPoint);
        return new Point3(this.dummyPoint.getX(), this.dummyPoint.getY(), 0.0);
    }

    public Point3 inverseTransform(double x, double y, double z) {
        this.dummyPoint.setLocation(x, y);
        this.xT.transform(this.dummyPoint, this.dummyPoint);
        return new Point3(this.dummyPoint.getX(), this.dummyPoint.getY(), 0.0);
    }

    public Point3 transform(Point3 p) {
        this.dummyPoint.setLocation(p.x, p.y);
        this.Tx.transform(this.dummyPoint, this.dummyPoint);
        p.set(this.dummyPoint.getX(), this.dummyPoint.getY(), 0.0);
        return p;
    }

    public Point3 inverseTransform(Point3 p) {
        this.dummyPoint.setLocation(p.x, p.y);
        this.xT.transform(this.dummyPoint, this.dummyPoint);
        p.set(this.dummyPoint.getX(), this.dummyPoint.getY(), 0.0);
        return p;
    }

    public void pushTransform() {
        this.matrixStack.push(new AffineTransform());
    }

    public void beginTransform() {
    }

    public void setIdentity() {
        this.Tx.setToIdentity();
    }

    public void translate(double tx, double ty, double tz) {
        this.Tx.translate(tx, ty);
    }

    public void rotate(double angle, double ax, double ay, double az) {
        this.Tx.rotate(angle, ax, ay, az);
    }

    public void scale(double sx, double sy, double sz) {
        this.Tx.scale(sx, sy);
    }

    public void endTransform() {
        this.computeInverse();
    }

    private void computeInverse() {
        try {
            this.xT = new AffineTransform(this.Tx);
            this.xT.invert();
        }
        catch (NoninvertibleTransformException e) {
            Logger.getLogger(this.getClass().getSimpleName()).log(Level.WARNING, "Cannot inverse matrix.", e);
        }
    }

    public void popTransform() {
        assert (!this.matrixStack.isEmpty());
    }

    public void setAntialias(Boolean on) {
    }

    public void setQuality(Boolean on) {
    }

    public Shape chooseNodeShape(Shape oldShape, StyleGroup group) {
        switch (group.getShape()) {
            case CIRCLE: {
                if (oldShape instanceof CircleShape) {
                    return oldShape;
                }
                return new CircleShape();
            }
            case BOX: {
                if (oldShape instanceof SquareShape) {
                    return oldShape;
                }
                return new SquareShape();
            }
            case ROUNDED_BOX: {
                if (oldShape instanceof RoundedSquareShape) {
                    return oldShape;
                }
                return new RoundedSquareShape();
            }
            case DIAMOND: {
                if (oldShape instanceof DiamondShape) {
                    return oldShape;
                }
                return new DiamondShape();
            }
            case TRIANGLE: {
                if (oldShape instanceof TriangleShape) {
                    return oldShape;
                }
                return new TriangleShape();
            }
            case CROSS: {
                if (oldShape instanceof CrossShape) {
                    return oldShape;
                }
                return new CrossShape();
            }
            case FREEPLANE: {
                if (oldShape instanceof FreePlaneNodeShape) {
                    return oldShape;
                }
                return new FreePlaneNodeShape();
            }
            case PIE_CHART: {
                if (oldShape instanceof PieChartShape) {
                    return oldShape;
                }
                return new PieChartShape();
            }
            case POLYGON: {
                if (oldShape instanceof PolygonShape) {
                    return oldShape;
                }
                return new PolygonShape();
            }
            case TEXT_BOX: {
                Logger.getLogger(this.getClass().getSimpleName()).warning("** SORRY text-box shape not yet implemented **");
                return new SquareShape();
            }
            case TEXT_PARAGRAPH: {
                Logger.getLogger(this.getClass().getSimpleName()).warning("** SORRY text-para shape not yet implemented **");
                return new SquareShape();
            }
            case TEXT_CIRCLE: {
                Logger.getLogger(this.getClass().getSimpleName()).warning("** SORRY text-circle shape not yet implemented **");
                return new CircleShape();
            }
            case TEXT_DIAMOND: {
                Logger.getLogger(this.getClass().getSimpleName()).warning("** SORRY text-diamond shape not yet implemented **");
                return new CircleShape();
            }
            case ARROW: {
                Logger.getLogger(this.getClass().getSimpleName()).warning("** SORRY arrow shape not yet implemented **");
                return new CircleShape();
            }
            case IMAGES: {
                Logger.getLogger(this.getClass().getSimpleName()).warning("** SORRY images shape not yet implemented **");
                return new SquareShape();
            }
            case JCOMPONENT: {
                throw new RuntimeException("Jcomponent should have its own renderer");
            }
        }
        throw new RuntimeException(group.getShape().toString() + " shape cannot be set for nodes");
    }

    public Shape chooseEdgeShape(Shape oldShape, StyleGroup group) {
        switch (group.getShape()) {
            case LINE: {
                if (oldShape instanceof LineShape) {
                    return oldShape;
                }
                return new LineShape();
            }
            case ANGLE: {
                if (oldShape instanceof AngleShape) {
                    return oldShape;
                }
                return new AngleShape();
            }
            case BLOB: {
                if (oldShape instanceof BlobShape) {
                    return oldShape;
                }
                return new BlobShape();
            }
            case CUBIC_CURVE: {
                if (oldShape instanceof CubicCurveShape) {
                    return oldShape;
                }
                return new CubicCurveShape();
            }
            case FREEPLANE: {
                if (oldShape instanceof FreePlaneEdgeShape) {
                    return oldShape;
                }
                return new FreePlaneEdgeShape();
            }
            case POLYLINE: {
                if (oldShape instanceof PolylineEdgeShape) {
                    return oldShape;
                }
                return new PolylineEdgeShape();
            }
            case SQUARELINE: {
                Logger.getLogger(this.getClass().getSimpleName()).warning("** SORRY square-line shape not yet implemented **");
                return new HorizontalSquareEdgeShape();
            }
            case LSQUARELINE: {
                if (oldShape instanceof LSquareEdgeShape) {
                    return oldShape;
                }
                return new LSquareEdgeShape();
            }
            case HSQUARELINE: {
                if (oldShape instanceof HorizontalSquareEdgeShape) {
                    return oldShape;
                }
                return new HorizontalSquareEdgeShape();
            }
            case VSQUARELINE: {
                Logger.getLogger(this.getClass().getSimpleName()).warning("** SORRY square-line shape not yet implemented **");
                return new HorizontalSquareEdgeShape();
            }
        }
        throw new RuntimeException(group.getShape() + " shape cannot be set for edges");
    }

    public Shape chooseEdgeArrowShape(Shape oldShape, StyleGroup group) {
        switch (group.getArrowShape()) {
            case NONE: {
                return null;
            }
            case ARROW: {
                if (oldShape instanceof ArrowOnEdge) {
                    return oldShape;
                }
                return new ArrowOnEdge();
            }
            case CIRCLE: {
                if (oldShape instanceof CircleOnEdge) {
                    return oldShape;
                }
                return new CircleOnEdge();
            }
            case DIAMOND: {
                if (oldShape instanceof DiamondOnEdge) {
                    return oldShape;
                }
                return new DiamondOnEdge();
            }
            case IMAGE: {
                if (oldShape instanceof ImageOnEdge) {
                    return oldShape;
                }
                return new ImageOnEdge();
            }
        }
        throw new RuntimeException(group.getArrowShape().toString() + " shape cannot be set for edge arrows");
    }

    public Shape chooseSpriteShape(Shape oldShape, StyleGroup group) {
        switch (group.getShape()) {
            case CIRCLE: {
                if (oldShape instanceof CircleShape) {
                    return oldShape;
                }
                return new CircleShape();
            }
            case BOX: {
                if (oldShape instanceof OrientableSquareShape) {
                    return oldShape;
                }
                return new OrientableSquareShape();
            }
            case ROUNDED_BOX: {
                if (oldShape instanceof RoundedSquareShape) {
                    return oldShape;
                }
                return new RoundedSquareShape();
            }
            case DIAMOND: {
                if (oldShape instanceof DiamondShape) {
                    return oldShape;
                }
                return new DiamondShape();
            }
            case TRIANGLE: {
                if (oldShape instanceof TriangleShape) {
                    return oldShape;
                }
                return new TriangleShape();
            }
            case CROSS: {
                if (oldShape instanceof CrossShape) {
                    return oldShape;
                }
                return new CrossShape();
            }
            case ARROW: {
                if (oldShape instanceof SpriteArrowShape) {
                    return oldShape;
                }
                return new SpriteArrowShape();
            }
            case FLOW: {
                if (oldShape instanceof SpriteFlowShape) {
                    return oldShape;
                }
                return new SpriteFlowShape();
            }
            case PIE_CHART: {
                if (oldShape instanceof PieChartShape) {
                    return oldShape;
                }
                return new PieChartShape();
            }
            case POLYGON: {
                if (oldShape instanceof PolygonShape) {
                    return oldShape;
                }
                return new PolygonShape();
            }
            case TEXT_BOX: {
                Logger.getLogger(this.getClass().getSimpleName()).warning("** SORRY text-box shape not yet implemented **");
                return new SquareShape();
            }
            case TEXT_PARAGRAPH: {
                Logger.getLogger(this.getClass().getSimpleName()).warning("** SORRY text-para shape not yet implemented **");
                return new SquareShape();
            }
            case TEXT_CIRCLE: {
                Logger.getLogger(this.getClass().getSimpleName()).warning("** SORRY text-circle shape not yet implemented **");
                return new CircleShape();
            }
            case TEXT_DIAMOND: {
                Logger.getLogger(this.getClass().getSimpleName()).warning("** SORRY text-diamond shape not yet implemented **");
                return new CircleShape();
            }
            case IMAGES: {
                Logger.getLogger(this.getClass().getSimpleName()).warning("** SORRY images shape not yet implemented **");
                return new SquareShape();
            }
            case JCOMPONENT: {
                throw new RuntimeException("Jcomponent should have its own renderer");
            }
        }
        throw new RuntimeException(group.getShape().toString() + " shape cannot be set for nodes");
    }

    public GraphBackgroundRenderer chooseGraphBackgroundRenderer() {
        return null;
    }

    public Container drawingSurface() {
        return this.surface;
    }
}

