/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.genids;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.modules.gedcom.genids.GenIDPanel;
import ancestris.modules.gedcom.genids.GenerateIDTask;
import ancestris.modules.gedcom.genids.GenerateIDTaskFactory;
import ancestris.util.ProgressListener;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.util.Trackable;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import spin.Spin;

public final class GenerateIDAction
extends AbstractAncestrisContextAction {
    private Gedcom gedcom = null;

    public GenerateIDAction() {
        this.setIconBase("ancestris/modules/gedcom/genids/GenIDsIcon.png");
        this.setText(NbBundle.getMessage(GenerateIDAction.class, (String)"CTL_GenerateIDAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        this.gedcom = this.getContext().getGedcom();
        GenIDPanel genidPanel = new GenIDPanel(this.getContext());
        Object choice = DialogManager.create((String)NbBundle.getMessage(GenerateIDAction.class, (String)"GenerateIDAction.AskParams"), (JComponent)genidPanel).setMessageType(3).setOptionType(2).setDialogId("genidPanel").show();
        if (choice == DialogManager.OK_OPTION) {
            genidPanel.savePreferences();
            GenerateIDTask task = (GenerateIDTask)Spin.off((Object)GenerateIDTaskFactory.create(this.gedcom, genidPanel.getSettings()));
            ProgressListener.Dispatcher.processStarted((Trackable)task);
            this.commit(task);
            ProgressListener.Dispatcher.processStopped((Trackable)task);
        }
    }

    private void commit(Runnable task) {
        block5: {
            try {
                if (this.gedcom.isWriteLocked()) {
                    task.run();
                    break block5;
                }
                this.gedcom.doUnitOfWork(localGedcom -> task.run());
            }
            catch (GedcomException ge) {
                Exceptions.printStackTrace((Throwable)ge);
            }
        }
    }
}

