/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import org.graphstream.algorithm.Toolkit;
import org.graphstream.algorithm.generator.BaseGenerator;

public class RandomFixedDegreeDynamicGraphGenerator
extends BaseGenerator {
    protected int nbVertices;
    protected double meanDegreeLimit;
    protected double nervousness;
    protected int step = 1;
    protected int deltaStep = 100;
    protected int currentNodeId = 0;

    public RandomFixedDegreeDynamicGraphGenerator() {
        this(50, 5.0, 0.1f);
    }

    public RandomFixedDegreeDynamicGraphGenerator(int nbVertices, double meanDegreeLimit, double nervousness) {
        this.setUseInternalGraph(true);
        this.nbVertices = nbVertices;
        this.meanDegreeLimit = meanDegreeLimit;
        this.nervousness = nervousness;
    }

    public double meanDegree() {
        return 2.0 * (double)this.internalGraph.getEdgeCount() / (double)this.internalGraph.getNodeCount();
    }

    protected String getEdgeId(String src, String trg) {
        if (src.compareTo(trg) < 0) {
            return String.format("%s_%s", src, trg);
        }
        return String.format("%s_%s", trg, src);
    }

    @Override
    public void begin() {
        this.step = 0;
    }

    @Override
    public boolean nextEvents() {
        this.sendStepBegins(this.sourceId, this.step);
        int nbSuppressions = (int)((double)this.random.nextFloat() * ((double)this.internalGraph.getNodeCount() * this.nervousness));
        for (int r = 1; r <= nbSuppressions; ++r) {
            String dead = Toolkit.randomNode(this.internalGraph, this.random).getId();
            this.delNode(dead);
        }
        int nbCreations = (int)((double)this.random.nextFloat() * ((double)(this.nbVertices - this.internalGraph.getNodeCount()) * Math.log(this.step) / Math.log(this.step + this.deltaStep)));
        for (int c = 1; c <= nbCreations; ++c) {
            String nodeId = String.format("%d", this.currentNodeId++);
            this.addNode(nodeId);
        }
        double degreMoyen = this.meanDegree();
        int nbCreationsEdges = (int)((double)this.random.nextFloat() * ((this.meanDegreeLimit - degreMoyen) * (double)(this.internalGraph.getNodeCount() / 2) * Math.log(this.step) / Math.log(this.step + this.deltaStep)));
        if (this.internalGraph.getNodeCount() > 1) {
            for (int c = 1; c <= nbCreationsEdges; ++c) {
                String dest;
                String source;
                while ((source = Toolkit.randomNode(this.internalGraph, this.random).getId()).equals(dest = Toolkit.randomNode(this.internalGraph, this.random).getId())) {
                }
                String idEdge = this.getEdgeId(source, dest);
                while (this.internalGraph.getEdge(idEdge) != null || source.equals(dest)) {
                    dest = Toolkit.randomNode(this.internalGraph, this.random).getId();
                    idEdge = this.getEdgeId(source, dest);
                }
                this.addEdge(idEdge, source, dest);
            }
        }
        ++this.step;
        return false;
    }

    @Override
    public void end() {
        super.end();
    }
}

