/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import org.graphstream.algorithm.generator.BaseGenerator;
import org.graphstream.stream.Pipe;

public class RandomEuclideanGenerator
extends BaseGenerator
implements Pipe {
    protected int nodeNames = 0;
    protected int dimension = 2;
    protected double threshold = 0.1;

    public RandomEuclideanGenerator() {
        this.initDimension(2);
        this.setUseInternalGraph(true);
    }

    public RandomEuclideanGenerator(int dimension) {
        this.initDimension(dimension);
        this.setUseInternalGraph(true);
    }

    public RandomEuclideanGenerator(int dimension, boolean directed, boolean randomlyDirectedEdges) {
        super(directed, randomlyDirectedEdges);
        this.initDimension(dimension);
        this.setUseInternalGraph(true);
    }

    public RandomEuclideanGenerator(int dimension, boolean directed, boolean randomlyDirectedEdges, String nodeAttribute, String edgeAttribute) {
        super(directed, randomlyDirectedEdges, nodeAttribute, edgeAttribute);
        this.initDimension(dimension);
        this.setUseInternalGraph(true);
    }

    private void initDimension(int dimension) {
        this.dimension = dimension;
        if (dimension > 0) {
            if (dimension == 2) {
                super.addNodeAttribute("x");
                super.addNodeAttribute("y");
            } else if (dimension == 3) {
                super.addNodeAttribute("x");
                super.addNodeAttribute("y");
                super.addNodeAttribute("z");
            } else {
                for (int i = 0; i < dimension; ++i) {
                    super.addNodeAttribute("x" + i);
                }
            }
        } else {
            System.err.println("dimension has to be higher that zero");
        }
    }

    @Override
    public void begin() {
        String id = Integer.toString(this.nodeNames++);
        this.addNode(id);
    }

    @Override
    public boolean nextEvents() {
        String id = Integer.toString(this.nodeNames++);
        this.addNode(id);
        this.internalGraph.nodes().filter(n -> !id.equals(n.getId()) && this.distance(id, n.getId()) < this.threshold).forEach(n -> this.addEdge(id + "-" + n.getId(), id, n.getId()));
        return true;
    }

    @Override
    public void end() {
        super.end();
    }

    private double distance(String n1, String n2) {
        double d = 0.0;
        if (this.dimension == 2) {
            double x1 = this.internalGraph.getNode(n1).getNumber("x");
            double y1 = this.internalGraph.getNode(n1).getNumber("y");
            double x2 = this.internalGraph.getNode(n2).getNumber("x");
            double y2 = this.internalGraph.getNode(n2).getNumber("y");
            d = Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0);
        } else if (this.dimension == 3) {
            double x1 = this.internalGraph.getNode(n1).getNumber("x");
            double y1 = this.internalGraph.getNode(n1).getNumber("y");
            double x2 = this.internalGraph.getNode(n2).getNumber("x");
            double y2 = this.internalGraph.getNode(n2).getNumber("y");
            double z1 = this.internalGraph.getNode(n1).getNumber("z");
            double z2 = this.internalGraph.getNode(n2).getNumber("z");
            d = Math.pow(z1 - z2, 2.0) + Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0);
        } else {
            for (int i = 0; i < this.dimension; ++i) {
                double xi1 = this.internalGraph.getNode(n1).getNumber("x" + i);
                double xi2 = this.internalGraph.getNode(n2).getNumber("x" + i);
                d += Math.pow(xi1 - xi2, 2.0);
            }
        }
        return Math.sqrt(d);
    }

    public void setThreshold(double threshold) {
        if (threshold <= 1.0 && threshold >= 0.0) {
            this.threshold = threshold;
        }
    }

    protected void nodeAttributeHandling(String nodeId, String key, Object val) {
        int i;
        if (key != null && key.matches("x|y|z") && val instanceof Float && (i = key.charAt(0) - 120) < this.dimension) {
            this.internalGraph.getNode(nodeId).setAttribute(key, new Object[]{val});
        }
    }

    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
    }

    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
    }

    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
    }

    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
    }

    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
    }

    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
    }

    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.nodeAttributeHandling(nodeId, attribute, value);
    }

    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.nodeAttributeHandling(nodeId, attribute, newValue);
    }

    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
    }

    public void graphCleared(String sourceId, long timeId) {
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
    }

    public void stepBegins(String sourceId, long timeId, double step) {
    }
}

