/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.community;

import java.util.HashMap;
import java.util.Objects;
import java.util.TreeMap;
import org.graphstream.algorithm.community.DecentralizedCommunityAlgorithm;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public class EpidemicCommunityAlgorithm
extends DecentralizedCommunityAlgorithm {
    protected HashMap<Object, Double> communityScores;

    public EpidemicCommunityAlgorithm() {
    }

    public EpidemicCommunityAlgorithm(Graph graph) {
        super(graph);
    }

    public EpidemicCommunityAlgorithm(Graph graph, String marker) {
        super(graph, marker);
    }

    @Override
    public void computeNode(Node node) {
        this.communityScores(node);
        Object maxCommunity = null;
        Double maxScore = Double.NEGATIVE_INFINITY;
        TreeMap<Object, Double> scores = new TreeMap<Object, Double>(this.communityScores);
        for (Object c : scores.keySet()) {
            Double s = this.communityScores.get(c);
            if (!(s > maxScore) && (!Objects.equals(s, maxScore) || !(this.rng.nextDouble() >= 0.5))) continue;
            maxCommunity = c;
            maxScore = s;
        }
        if (maxCommunity == null) {
            this.originateCommunity(node);
        } else {
            node.setAttribute(this.marker, new Object[]{maxCommunity});
            node.setAttribute(this.marker + ".score", new Object[]{maxScore});
        }
    }

    protected void communityScores(Node u) {
        this.communityScores = new HashMap();
        u.enteringEdges().filter(e -> e.getOpposite(u).hasAttribute(this.marker)).forEach(e -> {
            Node v = e.getOpposite(u);
            if (this.communityScores.get(v.getAttribute(this.marker)) == null) {
                this.communityScores.put(v.getAttribute(this.marker), 1.0);
            } else {
                this.communityScores.put(v.getAttribute(this.marker), this.communityScores.get(v.getAttribute(this.marker)) + 1.0);
            }
        });
    }

    @Override
    protected void originateCommunity(Node node) {
        super.originateCommunity(node);
        node.setAttribute(this.marker + ".score", new Object[]{0.0});
    }
}

