/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.stream.Stream;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.algorithm.util.Parameter;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.Path;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SinkAdapter;

public class APSP
extends SinkAdapter
implements Algorithm {
    protected Graph graph;
    protected boolean graphChanged = false;
    protected boolean directed = true;
    public static final String DEFAULT_WEIGHT_ATTRIBUTE = "weight";
    protected String weightAttributeName;
    protected Progress progress = null;
    private String source = "";
    private String target = "";

    public APSP() {
        this(null);
    }

    public APSP(Graph graph) {
        this(graph, DEFAULT_WEIGHT_ATTRIBUTE, true);
    }

    public APSP(Graph graph, String weightAttributeName, boolean directed) {
        this.graph = graph;
        this.weightAttributeName = weightAttributeName;
        this.directed = directed;
        this.init(graph);
    }

    public boolean isDirected() {
        return this.directed;
    }

    public String getWeightAttributeName() {
        return this.weightAttributeName;
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Parameter
    public void setDirected(boolean on) {
        this.directed = on;
    }

    public void registerProgressIndicator(Progress progress) {
        this.progress = progress;
    }

    @Parameter
    public void setWeightAttributeName(String name) {
        this.weightAttributeName = name;
    }

    @Override
    public void init(Graph graph) {
        if (this.graph != null) {
            this.graph.removeSink((Sink)this);
        }
        this.graph = graph;
        if (this.graph != null) {
            this.graphChanged = true;
            this.graph.addSink((Sink)this);
        }
    }

    @Parameter(value=true)
    public void setSource(String source) {
        this.source = source;
    }

    @Parameter(value=true)
    public void setTarget(String target) {
        this.target = target;
    }

    @Result
    public String defaultResult() {
        APSPInfo info = (APSPInfo)this.graph.getNode(this.source).getAttribute("APSPInfo");
        return info.getShortestPathTo(this.target).toString();
    }

    @Override
    public void compute() {
        if (this.graphChanged) {
            ArrayList nodeList = new ArrayList();
            this.graph.nodes().forEach(node -> {
                node.setAttribute("APSPInfo", new Object[]{new APSPInfo((Node)node, this.weightAttributeName, this.directed)});
                nodeList.add(node);
            });
            DoubleAccumulator prog = new DoubleAccumulator((x, y) -> x + y, 0.0);
            double MAX = nodeList.size() * nodeList.size();
            nodeList.stream().forEach(k -> nodeList.stream().forEach(i -> {
                nodeList.stream().forEach(j -> {
                    APSPInfo I = (APSPInfo)i.getAttribute("APSPInfo", APSPInfo.class);
                    APSPInfo J = (APSPInfo)j.getAttribute("APSPInfo", APSPInfo.class);
                    APSPInfo K = (APSPInfo)k.getAttribute("APSPInfo", APSPInfo.class);
                    double Dij = I.getLengthTo(J.source.getId());
                    double Dik = I.getLengthTo(K.source.getId());
                    double Dkj = K.getLengthTo(J.source.getId());
                    if (Dik >= 0.0 && Dkj >= 0.0) {
                        double sum = Dik + Dkj;
                        if (Dij >= 0.0) {
                            if (sum < Dij) {
                                I.setLengthTo(J, sum, K);
                            }
                        } else {
                            I.setLengthTo(J, sum, K);
                        }
                    }
                });
                if (this.progress != null) {
                    this.progress.progress(prog.get() / MAX);
                }
                prog.accumulate(1.0);
            }));
        }
        this.graphChanged = false;
    }

    public void nodeAdded(String graphId, long timeId, String nodeId) {
        this.graphChanged = true;
    }

    public void nodeRemoved(String graphId, long timeId, String nodeId) {
        this.graphChanged = true;
    }

    public void edgeAdded(String graphId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.graphChanged = true;
    }

    public void edgeRemoved(String graphId, long timeId, String edgeId) {
        this.graphChanged = true;
    }

    public void graphCleared(String graphId, long timeId) {
        this.graphChanged = true;
    }

    public void edgeAttributeAdded(String graphId, long timeId, String edgeId, String attribute, Object value) {
        if (attribute.equals(this.weightAttributeName)) {
            this.graphChanged = true;
        }
    }

    public void edgeAttributeChanged(String graphId, long timeId, String edgeId, String attribute, Object oldValue, Object value) {
        if (attribute.equals(this.weightAttributeName)) {
            this.graphChanged = true;
        }
    }

    public static interface Progress {
        public void progress(double var1);
    }

    public static class APSPInfo {
        public static final String ATTRIBUTE_NAME = "APSPInfo";
        public Node source;
        public double maxLength = Double.MIN_VALUE;
        public double minLength = Double.MAX_VALUE;
        public HashMap<String, TargetPath> targets = new HashMap();

        public APSPInfo(Node node, String weightAttributeName, boolean directed) {
            Stream edges = node.leavingEdges();
            this.source = node;
            if (!directed) {
                edges = node.edges();
            }
            edges.forEach(edge -> {
                double weight = 1.0;
                Node other = edge.getOpposite(node);
                if (edge.hasAttribute(weightAttributeName)) {
                    weight = edge.getNumber(weightAttributeName);
                }
                this.targets.put(other.getId(), new TargetPath(other, weight, null));
            });
        }

        public String getNodeId() {
            return this.source.getId();
        }

        public double getLengthTo(String other) {
            if (this.targets.containsKey(other)) {
                return this.targets.get((Object)other).distance;
            }
            return -1.0;
        }

        public double getMinimumLength() {
            return this.minLength;
        }

        public double getMaximumLength() {
            return this.maxLength;
        }

        public void setLengthTo(APSPInfo other, double length, APSPInfo passBy) {
            this.targets.put(other.source.getId(), new TargetPath(other.source, length, passBy));
            if (length < this.minLength) {
                this.minLength = length;
            }
            if (length > this.maxLength) {
                this.maxLength = length;
            }
        }

        public Path getShortestPathTo(String other) {
            TargetPath tpath = this.targets.get(other);
            if (tpath != null) {
                Path path = new Path();
                ArrayList<Node> nodePath = new ArrayList<Node>();
                nodePath.add(this.source);
                nodePath.add(tpath.target);
                this.expandPath(1, this, tpath, nodePath);
                for (int i = 0; i < nodePath.size() - 1; ++i) {
                    path.add(nodePath.get(i), nodePath.get(i).getEdgeToward(nodePath.get(i + 1).getId()));
                }
                return path;
            }
            return null;
        }

        protected int expandPath(int pos, APSPInfo source, TargetPath path, ArrayList<Node> nodePath) {
            if (path.passBy != null) {
                nodePath.add(pos, path.passBy.source);
                TargetPath path1 = source.targets.get(path.passBy.source.getId());
                TargetPath path2 = path.passBy.targets.get(path.target.getId());
                int added1 = this.expandPath(pos, source, path1, nodePath);
                int added2 = this.expandPath(pos + 1 + added1, path.passBy, path2, nodePath);
                return added1 + added2 + 1;
            }
            return 0;
        }
    }

    public static class TargetPath {
        public Node target;
        public double distance;
        public APSPInfo passBy;

        public TargetPath(Node other, double distance, APSPInfo passBy) {
            this.target = other;
            this.distance = distance;
            this.passBy = passBy;
        }
    }
}

