/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Vector;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.WindowWaiter;
import org.netbeans.jemmy.operators.WindowOperator;
import org.netbeans.jemmy.util.WindowJob;

public class WindowManager
implements Timeoutable,
Outputable {
    private static long TIME_DELTA = 1000L;
    private static WindowManager manager;
    private Vector jobs;
    private Timeouts timeouts;
    private TestOut output;

    private WindowManager() {
        this.setTimeouts(JemmyProperties.getCurrentTimeouts());
        this.setOutput(JemmyProperties.getCurrentOutput());
        this.jobs = new Vector();
    }

    public static void addJob(WindowJob job) {
        manager.add(job);
    }

    public static void removeJob(WindowJob job) {
        manager.remove(job);
    }

    public static void performJob(WindowJob job) {
        while (manager.performJobOnce(job)) {
        }
    }

    @Override
    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    @Override
    public void setOutput(TestOut output) {
        this.output = output;
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(WindowJob job) {
        this.output.printLine("Starting job \"" + job.getDescription() + "\"");
        Vector vector = this.jobs;
        synchronized (vector) {
            JobThread thread = new JobThread(job);
            this.jobs.add(thread);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(WindowJob job) {
        this.output.printLine("Killing job \"" + job.getDescription() + "\"");
        Vector vector = this.jobs;
        synchronized (vector) {
            for (int i = 0; i < this.jobs.size(); ++i) {
                if (((JobThread)this.jobs.get((int)i)).job != job) continue;
                ((JobThread)this.jobs.get((int)i)).needStop = true;
                this.jobs.remove(i);
            }
        }
    }

    private boolean performJobOnce(WindowJob job) {
        Window win = WindowWaiter.getWindow(job);
        if (win != null) {
            job.launch(win);
            return true;
        }
        return false;
    }

    static {
        Timeouts.initDefault("WindowManager.TimeDelta", TIME_DELTA);
        manager = new WindowManager();
    }

    private static class JobThread
    extends Thread {
        WindowJob job;
        boolean needStop = false;

        public JobThread(WindowJob job) {
            this.job = job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean getNS() {
            JobThread jobThread = this;
            synchronized (jobThread) {
                return this.needStop;
            }
        }

        @Override
        public void run() {
            while (!this.getNS()) {
                manager.performJobOnce(this.job);
                manager.timeouts.sleep("WindowManager.TimeDelta");
            }
        }
    }

    public static class ModalDialogChoosingJob
    implements WindowJob {
        @Override
        public boolean checkComponent(Component comp) {
            return comp instanceof Dialog && ((Dialog)comp).isModal();
        }

        @Override
        public Object launch(Object obj) {
            new WindowOperator((Window)obj).close();
            return null;
        }

        @Override
        public String getDescription() {
            return "A job of closing modal dialogs";
        }
    }
}

