/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util;

import genj.util.Registry;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbPreferences;

public class StartAndStopPanel
extends JPanel {
    private static Logger LOG;
    private String msg;
    private ResourceBundle bundle;
    private boolean darkModeChanged;
    private JPanel colorRecoPanel;
    private JLabel contrastChangeLabel;
    private JCheckBox resetColorsCheckBox;
    private JLabel startAndStopLabel;

    public StartAndStopPanel(String msg, boolean darkModeChanged, ResourceBundle bundle) {
        this.msg = msg;
        this.darkModeChanged = darkModeChanged;
        this.bundle = bundle;
        LOG = Logger.getLogger("ancestris.StartAndStop");
        this.initComponents();
        this.colorRecoPanel.setVisible(darkModeChanged);
        this.resetColorsCheckBox.setSelected(darkModeChanged);
    }

    private void initComponents() {
        this.startAndStopLabel = new JLabel();
        this.colorRecoPanel = new JPanel();
        this.contrastChangeLabel = new JLabel();
        this.resetColorsCheckBox = new JCheckBox();
        this.startAndStopLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/app/restart.png")));
        Mnemonics.setLocalizedText((JLabel)this.startAndStopLabel, (String)this.msg);
        Mnemonics.setLocalizedText((JLabel)this.contrastChangeLabel, (String)this.bundle.getString("NeedStopStart.contrastChangeLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.resetColorsCheckBox, (String)this.bundle.getString("NeedStopStart.resetColorsCheckBox"));
        GroupLayout colorRecoPanelLayout = new GroupLayout(this.colorRecoPanel);
        this.colorRecoPanel.setLayout(colorRecoPanelLayout);
        colorRecoPanelLayout.setHorizontalGroup(colorRecoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(colorRecoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.contrastChangeLabel, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(colorRecoPanelLayout.createSequentialGroup().addGap(219, 219, 219).addComponent(this.resetColorsCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        colorRecoPanelLayout.setVerticalGroup(colorRecoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(colorRecoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.contrastChangeLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetColorsCheckBox).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.startAndStopLabel, -1, -1, Short.MAX_VALUE).addComponent(this.colorRecoPanel, -1, -1, Short.MAX_VALUE)).addContainerGap(24, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.colorRecoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.startAndStopLabel).addContainerGap()));
    }

    public void processDarkModeChange() {
        if (this.darkModeChanged && this.resetColorsCheckBox.isSelected()) {
            this.resetReportsColors();
        }
    }

    private void resetReportsColors() {
        try {
            String[] dirs;
            for (String dir : dirs = new String[]{"reports", "report/svgtree"}) {
                String[] nodes;
                Preferences preferences = NbPreferences.root().node("ancestris/" + dir);
                for (String node : nodes = preferences.childrenNames()) {
                    Registry registry = Registry.get((String)("ancestris/" + dir + "/" + node));
                    registry.remove("bgColor");
                    registry.remove("fgText");
                    registry.remove("bgOddRow");
                    registry.remove("bgEvenRow");
                    registry.remove("bgHeaderRow");
                }
            }
        }
        catch (BackingStoreException ex) {
            LOG.log(Level.INFO, "Unable to remove colors", ex);
        }
    }
}

