/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.geo;

import ancestris.api.place.ShowPlace;
import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.modules.geo.GeoMapTopComponent;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.util.Resources;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Icon;
import org.jxmapviewer.viewer.GeoPosition;
import org.openide.util.LookupEvent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ShowPlaceAction
extends AbstractAncestrisContextAction {
    private PropertyPlace pPlace;
    private static final Resources RESOURCES = Resources.get(ShowPlaceAction.class);

    public void resultChanged(LookupEvent ev) {
        this.setEnabled(false);
        if (this.lkpInfo != null) {
            this.pPlace = null;
            for (Property prop : this.lkpInfo.allInstances()) {
                if (!(prop instanceof PropertyPlace)) continue;
                this.pPlace = (PropertyPlace)prop;
            }
            super.resultChanged(ev);
        }
    }

    protected void contextChanged() {
        super.contextChanged();
        this.setImage((Icon)PropertyPlace.IMAGE);
        this.setText(RESOURCES.getString("ACTION_ShowPlace").replaceAll("&", ""));
        this.setTip(RESOURCES.getString("ACTION_ShowPlace.tip"));
        this.setEnabled(this.pPlace != null && this.pPlace.getGeoPosition() != null);
    }

    public boolean isDefault(Property prop) {
        return prop instanceof PropertyPlace;
    }

    protected void actionPerformedImpl(ActionEvent event) {
        if (this.pPlace != null) {
            GeoPosition gp = this.pPlace.getGeoPosition();
            Collection showers = AncestrisPlugin.lookupAll(ShowPlace.class);
            if (showers.isEmpty()) {
                this.getMapTopComponent(this.pPlace.getGedcom());
                showers = AncestrisPlugin.lookupAll(ShowPlace.class);
            }
            if (!showers.isEmpty()) {
                for (ShowPlace shower : showers) {
                    shower.showPlace(gp);
                }
            }
            return;
        }
    }

    private GeoMapTopComponent getMapTopComponent(Gedcom gedcom) {
        GeoMapTopComponent theList = null;
        for (TopComponent tc : WindowManager.getDefault().getRegistry().getOpened()) {
            GeoMapTopComponent gmtc;
            if (!(tc instanceof GeoMapTopComponent) || (gmtc = (GeoMapTopComponent)tc).getGedcom() != gedcom) continue;
            theList = gmtc;
            break;
        }
        if (theList == null) {
            theList = new GeoMapTopComponent();
            theList.init(new Context(gedcom));
            theList.open();
        }
        return theList;
    }
}

