/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.uihandler;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JButton;
import org.netbeans.lib.uihandler.Decorable;
import org.openide.util.NbBundle;

final class Decorations {
    private static final SimpleFormatter FORMATTER = new SimpleFormatter();

    Decorations() {
    }

    static void decorate(LogRecord r, Decorable d) {
        String htmlKey;
        if (r.getMessage() == null) {
            d.setName("Seq: " + r.getSequenceNumber());
        } else {
            d.setName(r.getMessage());
        }
        if (r.getResourceBundle() != null) {
            try {
                String msg = r.getResourceBundle().getString(r.getMessage());
                if (r.getParameters() != null) {
                    msg = MessageFormat.format(msg, r.getParameters());
                }
                d.setDisplayName(msg);
            }
            catch (MissingResourceException ex) {
                Logger.getAnonymousLogger().log(Level.INFO, null, ex);
            }
            try {
                String iconBase = r.getResourceBundle().getString(r.getMessage() + "_ICON_BASE");
                d.setIconBaseWithExtension(iconBase);
            }
            catch (MissingResourceException ex) {
                d.setIconBaseWithExtension("org/netbeans/lib/uihandler/def.png");
            }
        }
        if (r.getThrown() != null) {
            d.setIconBaseWithExtension("org/netbeans/lib/uihandler/exception.gif");
            String ex = "HTML_exception";
        }
        if ("UI_ACTION_BUTTON_PRESS".equals(r.getMessage())) {
            d.setDisplayName(Decorations.cutAmpersand(Decorations.getParam(r, 4)));
            String thru = Decorations.getParam(r, 1, String.class);
            if (thru != null && thru.contains("Toolbar") || Decorations.getParam(r, 0, Object.class) instanceof JButton) {
                d.setIconBaseWithExtension("org/netbeans/lib/uihandler/toolbars.gif");
                htmlKey = "HTML_toolbar";
            } else if (thru != null && thru.contains("MenuItem")) {
                d.setIconBaseWithExtension("org/netbeans/lib/uihandler/menus.gif");
                htmlKey = "HTML_menu";
            }
        } else if ("UI_ACTION_KEY_PRESS".equals(r.getMessage())) {
            d.setDisplayName(Decorations.cutAmpersand(Decorations.getParam(r, 4)));
            d.setIconBaseWithExtension("org/netbeans/lib/uihandler/key.png");
            htmlKey = "HTML_key";
        } else if ("UI_ACTION_EDITOR".equals(r.getMessage())) {
            d.setDisplayName(Decorations.cutAmpersand(Decorations.getParam(r, 4)));
            d.setIconBaseWithExtension("org/netbeans/lib/uihandler/key.png");
            htmlKey = "HTML_key";
        } else if ("UI_ENABLED_MODULES".equals(r.getMessage())) {
            d.setDisplayName(NbBundle.getMessage(Decorations.class, (String)"MSG_EnabledModules"));
            d.setIconBaseWithExtension("org/netbeans/lib/uihandler/module.gif");
            htmlKey = null;
        } else if ("UI_DISABLED_MODULES".equals(r.getMessage())) {
            d.setDisplayName(NbBundle.getMessage(Decorations.class, (String)"MSG_DisabledModules"));
            d.setIconBaseWithExtension("org/netbeans/lib/uihandler/module.gif");
            htmlKey = null;
        } else if ("UI_USER_CONFIGURATION".equals(r.getMessage())) {
            d.setDisplayName(NbBundle.getMessage(Decorations.class, (String)"MSG_USER_CONFIGURATION"));
            Object var2_2 = null;
        }
        d.setShortDescription(FORMATTER.format(r));
    }

    private static <T> T getParam(LogRecord r, int index, Class<T> type) {
        if (r == null || r.getParameters() == null || r.getParameters().length <= index) {
            return null;
        }
        Object o = r.getParameters()[index];
        return type.isInstance(o) ? (T)type.cast(o) : null;
    }

    private static String getParam(LogRecord r, int index) {
        Object[] arr = r.getParameters();
        if (arr == null || arr.length <= index || !(arr[index] instanceof String)) {
            return "";
        }
        return (String)arr[index];
    }

    static String cutAmpersand(String text) {
        Object result = text;
        int i = text.indexOf("(&");
        result = i >= 0 && i + 3 < text.length() && text.charAt(i + 3) == ')' ? text.substring(0, i) + text.substring(i + 4) : ((i = text.indexOf(38)) < 0 ? text : (i == text.length() - 1 ? text.substring(0, i) : (" ".equals(text.substring(i + 1, i + 2)) ? text : text.substring(0, i) + text.substring(i + 1))));
        return result;
    }
}

