/*
 * Decompiled with CFR 0.152.
 */
package swingx.tree;

import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeModel
implements TreeModel {
    protected EventListenerList listenerList = new EventListenerList();

    protected abstract Object getParent(Object var1);

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void nodeChanged(Object node) {
        if (this.listenerList != null && node != null) {
            Object parent = this.getParent(node);
            if (parent != null) {
                int anIndex = this.getIndexOfChild(parent, node);
                if (anIndex != -1) {
                    int[] cIndexs = new int[]{anIndex};
                    this.nodesChanged(parent, cIndexs);
                }
            } else if (node == this.getRoot()) {
                this.nodesChanged(node, null);
            }
        }
    }

    public void nodesWereInserted(Object node, int[] childIndices) {
        if (this.listenerList != null && node != null && childIndices != null && childIndices.length > 0) {
            int cCount = childIndices.length;
            Object[] newChildren = new Object[cCount];
            for (int counter = 0; counter < cCount; ++counter) {
                newChildren[counter] = this.getChild(node, childIndices[counter]);
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot(node), childIndices, newChildren);
        }
    }

    public void nodesWereRemoved(Object node, int[] childIndices, Object[] removedChildren) {
        if (node != null && childIndices != null) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot(node), childIndices, removedChildren);
        }
    }

    public void nodesChanged(Object node, int[] childIndices) {
        if (node != null) {
            if (childIndices != null) {
                int cCount = childIndices.length;
                if (cCount > 0) {
                    Object[] cChildren = new Object[cCount];
                    for (int counter = 0; counter < cCount; ++counter) {
                        cChildren[counter] = this.getChild(node, childIndices[counter]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(node), childIndices, cChildren);
                }
            } else if (node == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
            }
        }
    }

    public void rootExchanged() {
        this.fireTreeStructureChanged(this, this.getPathToRoot(this.getRoot()), null, null);
    }

    public void nodeStructureChanged(Object node) {
        this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
    }

    public Object[] getPathToRoot(Object aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    protected Object[] getPathToRoot(Object aNode, int depth) {
        if (aNode == null) {
            return null;
        }
        Object[] retNodes = aNode == this.getRoot() ? new Object[depth] : this.getPathToRoot(this.getParent(aNode), ++depth);
        if (retNodes == null) {
            return null;
        }
        retNodes[retNodes.length - depth] = aNode;
        return retNodes;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path == null ? null : new TreePath(path), childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }
}

