/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.Grammar;
import genj.gedcom.PropertyEventDetails;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;

public class PropertyEvent
extends PropertyEventDetails {
    public static ImageIcon IMG = Grammar.V55.getMeta(new TagPath("INDI:EVEN")).getImage();
    private boolean knownToHaveHappened;
    private String description;

    public PropertyEvent(String tag) {
        super(tag);
    }

    @Override
    public String getValue() {
        if (this.description != null && !this.description.isEmpty()) {
            return this.description;
        }
        return this.knownToHaveHappened ? "Y" : "";
    }

    @Override
    public String getDisplayValue() {
        if (this.description != null && !this.description.isEmpty() && !this.knownToHaveHappened) {
            return this.description;
        }
        return this.knownToHaveHappened ? resources.getString("prop.event.knowntohavehappened") : "";
    }

    @Override
    public void setValue(String value) {
        this.setKnownToHaveHappened(value.toLowerCase().equals("y"));
        this.description = value;
    }

    public static TagPath[] getTagPaths(Gedcom gedcom) {
        return gedcom.getGrammar().getAllPaths(null, PropertyEvent.class);
    }

    public Boolean isKnownToHaveHappened() {
        if (this.getTag().equals("EVEN")) {
            return null;
        }
        return this.knownToHaveHappened;
    }

    public void setKnownToHaveHappened(boolean set) {
        String old = this.getValue();
        this.knownToHaveHappened = set;
        this.description = set ? "Y" : "";
        this.propagatePropertyChanged(this, old);
    }

    @Override
    public boolean isValid() {
        boolean hasPDChild;
        String tag = this.getTag();
        if (!GedcomConstants.TAG_YES_EVENTS.contains(tag)) {
            return true;
        }
        String value = this.getValue();
        boolean isNull = value.isEmpty();
        boolean isY = value.equals("Y");
        boolean isYesTag = GedcomConstants.TAG_YES_EVENTS.contains(tag);
        boolean hasChild = this.getNoOfProperties() > 0;
        boolean bl = hasPDChild = this.getProperty("PLAC", true) != null || this.getProperty("DATE", true) != null;
        if (isNull) {
            if (!hasChild) {
                if (isYesTag) {
                    this.invalidReason = "err.yestag.YvalueRequired";
                    return false;
                }
                return super.isValid();
            }
            return true;
        }
        if (isY) {
            if (isYesTag) {
                if (hasPDChild) {
                    this.invalidReason = "err.yestag.YvalueRedundant";
                    return false;
                }
                return true;
            }
            this.invalidReason = "err.yestag.YvalueForbidden";
            return false;
        }
        if (!isNull) {
            this.invalidReason = isYesTag ? (hasPDChild ? "err.yestag.nonYvalueForbidden" : "err.yestag.YvalueInstead") : "err.value.emptyRequired";
            return false;
        }
        return true;
    }
}

