/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Note;
import genj.gedcom.Repository;
import genj.gedcom.SNote;
import genj.gedcom.Source;
import genj.gedcom.Submitter;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GedcomConstants {
    public static final String DEST_ANY = "ANY";
    public static final String DEST_ANSTFILE = "ANSTFILE";
    public static final String DEST_TEMPLEREADY = "TempleReady";
    public static final String PASSWORD_UNKNOWN = "unknown";
    public static final String INDI = "INDI";
    public static final String FAM = "FAM";
    public static final String OBJE = "OBJE";
    public static final String NOTE = "NOTE";
    public static final String SNOTE = "SNOTE";
    public static final String SOUR = "SOUR";
    public static final String SUBM = "SUBM";
    public static final String REPO = "REPO";
    public static final String[] ENTITIES_5 = new String[]{"INDI", "FAM", "OBJE", "NOTE", "SOUR", "SUBM", "REPO"};
    public static final String[] ENTITIES_7 = new String[]{"INDI", "FAM", "OBJE", "SNOTE", "SOUR", "SUBM", "REPO"};
    public static final String[] ENTITIES = new String[]{"INDI", "FAM", "OBJE", "NOTE", "SNOTE", "SOUR", "SUBM", "REPO"};
    private static final Map<String, ImageIcon> E2_IMAGE = new HashMap<String, ImageIcon>();
    static final Map<String, String> E2PREFIX = new HashMap<String, String>();
    static final Map<String, Class<? extends Entity>> E2TYPE;
    public static final String TAG_NAME = ".name";
    public static final String VALS = ".vals";
    public static final String TAG_SOSADABOVILLE = "_SOSADABOVILLE";
    public static final String TAG_SOSA = "_SOSA";
    public static final String TAG_DABOVILLE = "_DABOVILLE";
    public static final String VALID_TAG = "_VALID";
    public static final String TAG_MARKING_PRIVATE = "_PRIV";
    public static final String TAG_PHRASE = "_PHRASE";
    public static final String DOC_EXTENSIONS = "https://docs.ancestris.org/books/user-guide/page/tags#bkmrk-ancestris-tags";
    public static final String[] EXTENSIONS;
    public static final Map<Grammar, Set<String>> TAG_ATTR_EVENTS_MAP;
    public static final Set<String> TAG_YES_EVENTS;

    private GedcomConstants() {
    }

    public static ImageIcon getEntityImage(String tag) {
        ImageIcon result = E2_IMAGE.get(tag);
        if (result == null) {
            result = Grammar.V70.getMeta(new TagPath(tag)).getImage();
            E2_IMAGE.put(tag, result);
        }
        return result;
    }

    static {
        E2PREFIX.put(INDI, "I");
        E2PREFIX.put(FAM, "F");
        E2PREFIX.put(OBJE, "M");
        E2PREFIX.put(NOTE, "N");
        E2PREFIX.put(SNOTE, "N");
        E2PREFIX.put(SOUR, "S");
        E2PREFIX.put(SUBM, "B");
        E2PREFIX.put(REPO, "R");
        E2TYPE = new HashMap<String, Class<? extends Entity>>();
        E2TYPE.put(INDI, Indi.class);
        E2TYPE.put(FAM, Fam.class);
        E2TYPE.put(OBJE, Media.class);
        E2TYPE.put(NOTE, Note.class);
        E2TYPE.put(SNOTE, SNote.class);
        E2TYPE.put(SOUR, Source.class);
        E2TYPE.put(SUBM, Submitter.class);
        E2TYPE.put(REPO, Repository.class);
        EXTENSIONS = new String[]{TAG_DABOVILLE, TAG_MARKING_PRIVATE, TAG_PHRASE, TAG_SOSA, TAG_SOSADABOVILLE, VALID_TAG};
        TAG_ATTR_EVENTS_MAP = new HashMap<Grammar, Set<String>>();
        TAG_ATTR_EVENTS_MAP.put(Grammar.V55, new HashSet<String>(Arrays.asList("CAST", "DSCR", "EDUC", "IDNO", "NATI", "NCHI", "NMR", "OCCU", "PROP", "RELI", "SSN", "TITL")));
        TAG_ATTR_EVENTS_MAP.put(Grammar.V551, new HashSet<String>(Arrays.asList("CAST", "DSCR", "EDUC", "IDNO", "NATI", "NCHI", "NMR", "OCCU", "PROP", "RELI", "SSN", "TITL", "FACT", "EVEN")));
        TAG_ATTR_EVENTS_MAP.put(Grammar.V70, new HashSet<String>(Arrays.asList("CAST", "DSCR", "EDUC", "IDNO", "NATI", "NCHI", "NMR", "OCCU", "PROP", "RELI", "SSN", "TITL", "FACT", "EVEN", "RESI", "NO")));
        TAG_YES_EVENTS = new HashSet<String>(Arrays.asList("BIRT", "CHR", "DEAT", "BURI", "CREM", "ADOP", "BAPM", "BARM", "BASM", "BLES", "CHRA", "CONF", "FCOM", "ORDN", "NATU", "EMIG", "IMMI", "CENS", "PROB", "WILL", "GRAD", "RETI", "ANUL", "DIV", "DIVF", "ENGA", "MARR", "MARB", "MARC", "MARL", "MARS"));
    }

    public static enum Encodings {
        UTF8("UTF-8"),
        UNICODE("UNICODE"),
        ANSEL("ANSEL"),
        ANSI("ANSI"),
        LATIN1("LATIN1"),
        ASCII("ASCII");

        private String affichage;

        private Encodings(String value) {
            this.affichage = value;
        }

        public String toString() {
            return this.affichage;
        }
    }
}

