/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.graphstream.stream.file.FileSource;
import org.graphstream.stream.file.FileSourceDGS;
import org.graphstream.stream.file.FileSourceDGS1And2;
import org.graphstream.stream.file.FileSourceDOT;
import org.graphstream.stream.file.FileSourceEdge;
import org.graphstream.stream.file.FileSourceGEXF;
import org.graphstream.stream.file.FileSourceGML;
import org.graphstream.stream.file.FileSourceGraphML;
import org.graphstream.stream.file.FileSourceLGL;
import org.graphstream.stream.file.FileSourceNCol;
import org.graphstream.stream.file.FileSourcePajek;
import org.graphstream.stream.file.FileSourceTLP;

public class FileSourceFactory {
    public static FileSource sourceFor(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.isFile()) {
            throw new IOException("not a regular file '" + fileName + "'");
        }
        if (!file.canRead()) {
            throw new IOException("not a readable file '" + fileName + "'");
        }
        RandomAccessFile in = new RandomAccessFile(fileName, "r");
        byte[] b = new byte[10];
        int n = in.read(b, 0, 10);
        in.close();
        if (n >= 3 && b[0] == 68 && b[1] == 71 && b[2] == 83 && n >= 6 && b[3] == 48 && b[4] == 48) {
            if (b[5] == 49 || b[5] == 50) {
                return new FileSourceDGS1And2();
            }
            if (b[5] == 51 || b[5] == 52) {
                return new FileSourceDGS();
            }
        }
        if (n >= 7 && b[0] == 103 && b[1] == 114 && b[2] == 97 && b[3] == 112 && b[4] == 104 && b[5] == 32 && b[6] == 91) {
            return new FileSourceGML();
        }
        if (n >= 4 && b[0] == 40 && b[1] == 116 && b[2] == 108 && b[3] == 112) {
            return new FileSourceTLP();
        }
        String flc = fileName.toLowerCase();
        if (flc.endsWith(".dgs")) {
            return new FileSourceDGS();
        }
        if (flc.endsWith(".gml") || flc.endsWith(".dgml")) {
            return new FileSourceGML();
        }
        if (flc.endsWith(".net")) {
            return new FileSourcePajek();
        }
        if (!flc.endsWith(".chaco")) {
            flc.endsWith(".graph");
        }
        if (flc.endsWith(".dot")) {
            return new FileSourceDOT();
        }
        if (flc.endsWith(".edge")) {
            return new FileSourceEdge();
        }
        if (flc.endsWith(".lgl")) {
            return new FileSourceLGL();
        }
        if (flc.endsWith(".ncol")) {
            return new FileSourceNCol();
        }
        if (flc.endsWith(".tlp")) {
            return new FileSourceTLP();
        }
        if (flc.endsWith(".xml")) {
            String root = FileSourceFactory.getXMLRootElement(fileName);
            if (root.equalsIgnoreCase("gexf")) {
                return new FileSourceGEXF();
            }
            return new FileSourceGraphML();
        }
        if (flc.endsWith(".gexf")) {
            return new FileSourceGEXF();
        }
        return null;
    }

    public static String getXMLRootElement(String fileName) throws IOException {
        FileReader stream = new FileReader(fileName);
        try {
            XMLEvent e;
            XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(stream);
            while (!(e = reader.nextEvent()).isStartElement() && !e.isEndDocument()) {
            }
            if (e.isEndDocument()) {
                throw new IOException("document ended before catching root element");
            }
            String root = e.asStartElement().getName().getLocalPart();
            reader.close();
            stream.close();
            return root;
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
        catch (FactoryConfigurationError ex) {
            throw new IOException(ex);
        }
    }
}

