/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.modules.autoupdate.ui.Bundle;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class LocalDownloadSupport {
    private static final FileFilter NBM_FILE_FILTER = new NbmFileFilter();
    private static final FileFilter OSGI_BUNDLE_FILTER = new OsgiBundleFilter();
    private static final String LOCAL_DOWNLOAD_DIRECTORY_KEY = "local-download-directory";
    private static final String LOCAL_DOWNLOAD_FILES = "local-download-files";
    private static final String LOCAL_DOWNLOAD_CHECKED_FILES = "local-download-checked-files";
    private final FileList fileList = new FileList();
    private static final Logger err = Logger.getLogger(LocalDownloadSupport.class.getName());
    private Map<File, String> nbm2unitCodeName = null;
    private Map<String, UpdateUnit> codeName2unit = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chooseNbmFiles() {
        Window parent;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.addChoosableFileFilter(NBM_FILE_FILTER);
        chooser.addChoosableFileFilter(OSGI_BUNDLE_FILTER);
        chooser.setFileFilter(NBM_FILE_FILTER);
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileHidingEnabled(false);
        chooser.setDialogTitle(NbBundle.getMessage(LocalDownloadSupport.class, (String)"CTL_FileChooser_Title"));
        File dir = LocalDownloadSupport.getDefaultDir();
        if (dir != null && dir.exists()) {
            chooser.setCurrentDirectory(dir);
        }
        if (chooser.showOpenDialog(parent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == 0) {
            Class<LocalDownloadSupport> clazz = LocalDownloadSupport.class;
            synchronized (LocalDownloadSupport.class) {
                LocalDownloadSupport.getPreferences().put(LOCAL_DOWNLOAD_DIRECTORY_KEY, chooser.getCurrentDirectory().getAbsolutePath());
                this.fileList.addFiles(chooser.getSelectedFiles());
                this.addUpdateUnits(chooser.getSelectedFiles());
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UpdateUnit> getUpdateUnits() {
        Class<LocalDownloadSupport> clazz = LocalDownloadSupport.class;
        synchronized (LocalDownloadSupport.class) {
            LinkedList<UpdateUnit> res = new LinkedList<UpdateUnit>(this.getCodeName2Unit().values());
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return res;
        }
    }

    public void checkUnit(UpdateUnit updateUnit) {
        this.fileList.makePersistentCheckedFile(this.getNbm(updateUnit.getCodeName()));
    }

    public void uncheckUnit(UpdateUnit updateUnit) {
        this.fileList.makePersistentUncheckedFile(this.getNbm(updateUnit.getCodeName()));
    }

    public boolean isChecked(UpdateUnit unit) {
        return this.fileList.isChecked(this.getNbm(unit.getCodeName()));
    }

    private Collection<File> getAllFiles() {
        return this.fileList.getAllFiles();
    }

    final void addUpdateUnits(File ... newFiles) {
        HashSet<UpdateUnit> alreadyInstalled = new HashSet<UpdateUnit>();
        for (File nbm : newFiles) {
            UpdateUnit u = null;
            if (NBM_FILE_FILTER.accept(nbm) || OSGI_BUNDLE_FILTER.accept(nbm)) {
                u = this.createUpdateUnitFromNBM(nbm, false);
            }
            if (u != null) {
                if (u.getAvailableUpdates() == null || u.getAvailableUpdates().isEmpty()) {
                    alreadyInstalled.add(u);
                    continue;
                }
                if (this.getCodeName2Unit().containsKey(u.getCodeName())) {
                    File looserFile;
                    UpdateUnit looserUnit;
                    File winnerFile;
                    UpdateUnit winnerUnit;
                    UpdateElement uE1 = (UpdateElement)u.getAvailableUpdates().get(0);
                    UpdateElement uE2 = (UpdateElement)this.getCodeName2Unit().get(u.getCodeName()).getAvailableUpdates().get(0);
                    String name1 = NbBundle.getMessage(LocalDownloadSupport.class, (String)"NotificationPlugin", (Object)uE1.getDisplayName(), (Object)uE1.getSpecificationVersion());
                    String name2 = NbBundle.getMessage(LocalDownloadSupport.class, (String)"NotificationPlugin", (Object)uE2.getDisplayName(), (Object)uE2.getSpecificationVersion());
                    Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(LocalDownloadSupport.class, (String)"NotificationAlreadyPresent", (Object)name2, (Object)name1), NbBundle.getMessage(LocalDownloadSupport.class, (String)"NotificationAlreadyPresentTitle")));
                    if (NotifyDescriptor.YES_OPTION.equals(res)) {
                        winnerUnit = uE1.getUpdateUnit();
                        winnerFile = nbm;
                        looserUnit = uE2.getUpdateUnit();
                        looserFile = this.getNbm(winnerUnit.getCodeName());
                    } else {
                        if (!NotifyDescriptor.NO_OPTION.equals(res)) break;
                        winnerUnit = uE2.getUpdateUnit();
                        winnerFile = this.getNbm(winnerUnit.getCodeName());
                        looserUnit = uE1.getUpdateUnit();
                        looserFile = nbm;
                    }
                    this.getNbm2CodeName().remove(looserFile);
                    this.getCodeName2Unit().remove(looserUnit.getCodeName());
                    this.getNbm2CodeName().put(winnerFile, winnerUnit.getCodeName());
                    this.getCodeName2Unit().put(winnerUnit.getCodeName(), winnerUnit);
                    this.fileList.removeFile(looserFile);
                    Containers.forUpdateNbms().removeAll();
                    Containers.forAvailableNbms().removeAll();
                    continue;
                }
                this.getNbm2CodeName().put(nbm, u.getCodeName());
                this.getCodeName2Unit().put(u.getCodeName(), u);
                continue;
            }
            this.fileList.removeFile(nbm);
        }
        if (!alreadyInstalled.isEmpty()) {
            String msg = alreadyInstalled.size() == 1 ? NbBundle.getMessage(LocalDownloadSupport.class, (String)"NotificationOneAlreadyInstalled", (Object)this.getDisplayNames(alreadyInstalled)) : NbBundle.getMessage(LocalDownloadSupport.class, (String)"NotificationMoreAlreadyInstalled", (Object)this.getDisplayNames(alreadyInstalled));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 1));
        }
    }

    private synchronized void initCodeName2Unit() {
        assert (this.nbm2unitCodeName == null) : "Cannot initialize nbm2unit twice!";
        this.nbm2unitCodeName = new HashMap<File, String>();
        this.codeName2unit = new HashMap<String, UpdateUnit>();
        Iterator<File> it = this.getAllFiles().iterator();
        while (it.hasNext()) {
            File nbm = it.next();
            UpdateUnit u = this.createUpdateUnitFromNBM(nbm, true);
            if (u != null && !u.getAvailableUpdates().isEmpty()) {
                this.nbm2unitCodeName.put(nbm, u.getCodeName());
                this.codeName2unit.put(u.getCodeName(), u);
                continue;
            }
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<File, String> getNbm2CodeName() {
        Class<LocalDownloadSupport> clazz = LocalDownloadSupport.class;
        synchronized (LocalDownloadSupport.class) {
            if (this.nbm2unitCodeName == null) {
                this.initCodeName2Unit();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nbm2unitCodeName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, UpdateUnit> getCodeName2Unit() {
        Class<LocalDownloadSupport> clazz = LocalDownloadSupport.class;
        synchronized (LocalDownloadSupport.class) {
            if (this.codeName2unit == null) {
                this.initCodeName2Unit();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.codeName2unit;
        }
    }

    private String getUnitCodeName(File nbm) {
        assert (nbm != null) : "Invalid file " + nbm;
        if (nbm != null) {
            return this.getNbm2CodeName().get(nbm);
        }
        return null;
    }

    private File getNbm(String codeName) {
        assert (codeName != null) : "Invalid code name " + codeName;
        if (codeName != null) {
            for (File nbm : this.getNbm2CodeName().keySet()) {
                if (!codeName.equals(this.getUnitCodeName(nbm))) continue;
                return nbm;
            }
        }
        return null;
    }

    private UpdateUnit createUpdateUnitFromNBM(File nbm, boolean quiet) {
        List units;
        block4: {
            UpdateUnitProviderFactory factory = UpdateUnitProviderFactory.getDefault();
            UpdateUnitProvider provider = factory.create(nbm.getName(), new File[]{nbm});
            units = Collections.emptyList();
            try {
                units = provider.getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
            }
            catch (RuntimeException re) {
                if (quiet) break block4;
                err.log(Level.INFO, re.getMessage(), re);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)re, (Object)NbBundle.getMessage(LocalDownloadSupport.class, (String)"LocalDownloadSupport_BrokenNBM_Exception", (Object)nbm.getName(), (Object)re.getLocalizedMessage())));
                this.fileList.removeFile(nbm);
            }
        }
        if (units == null || units.isEmpty()) {
            return null;
        }
        assert (units.size() == 1) : "Only once UpdateUnit for " + nbm + " but " + units;
        return (UpdateUnit)units.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstalledUnit() {
        Class<LocalDownloadSupport> clazz = LocalDownloadSupport.class;
        synchronized (LocalDownloadSupport.class) {
            Iterator<UpdateUnit> it = this.getCodeName2Unit().values().iterator();
            while (it.hasNext()) {
                UpdateUnit u = it.next();
                if (u.getInstalled() == null || !u.getAvailableUpdates().isEmpty()) continue;
                it.remove();
                this.getNbm2CodeName().remove(this.getNbm(u.getCodeName()));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean remove(UpdateUnit unit) {
        File f = this.getNbm(unit.getCodeName());
        if (f != null) {
            this.fileList.removeFile(f);
            Class<LocalDownloadSupport> clazz = LocalDownloadSupport.class;
            // MONITORENTER : org.netbeans.modules.autoupdate.ui.LocalDownloadSupport.class
            File nbm = this.getNbm(unit.getCodeName());
            this.getCodeName2Unit().remove(unit.getCodeName());
            this.getNbm2CodeName().remove(nbm);
            // MONITOREXIT : clazz
        }
        if (f == null) return false;
        return true;
    }

    private static File getDefaultDir() {
        File retval = new File(LocalDownloadSupport.getPreferences().get(LOCAL_DOWNLOAD_DIRECTORY_KEY, System.getProperty("netbeans.user")));
        return retval.exists() ? retval : new File(System.getProperty("netbeans.user"));
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(LocalDownloadSupport.class);
    }

    private String getDisplayNames(Collection<UpdateUnit> units) {
        TreeSet<String> names = new TreeSet<String>();
        for (UpdateUnit uu : units) {
            if (uu.getInstalled() != null) {
                names.add(uu.getInstalled().getDisplayName());
                continue;
            }
            names.add(((UpdateElement)uu.getAvailableUpdates().get(0)).getDisplayName());
        }
        String res = "";
        for (String dn : names) {
            res = res + (res.length() == 0 ? dn : ", " + dn);
        }
        return res;
    }

    private static boolean isOSGiBundle(File jarFile) {
        try {
            JarFile jar = new JarFile(jarFile);
            Manifest mf = jar.getManifest();
            return mf != null && mf.getMainAttributes().getValue("Bundle-SymbolicName") != null;
        }
        catch (IOException ioe) {
            err.log(Level.INFO, ioe.getLocalizedMessage(), ioe);
            return false;
        }
    }

    private static class FileList {
        private Set<File> allFiles = null;
        private Set<File> checkedFiles = null;

        private FileList() {
        }

        Set<File> getAllFiles() {
            if (this.allFiles == null) {
                this.allFiles = new LinkedHashSet<File>();
                this.addFiles(this.loadPresistentState());
            }
            return this.allFiles;
        }

        Set<File> getCheckedFiles() {
            if (this.checkedFiles == null) {
                this.checkedFiles = new HashSet<File>();
                for (File f : this.getAllFiles()) {
                    if (!this.isChecked(f)) continue;
                    this.checkedFiles.add(f);
                }
            }
            return this.checkedFiles;
        }

        void addFiles(File[] files) {
            this.addFiles(Arrays.asList(files));
        }

        void addFiles(Collection<File> files) {
            this.getAllFiles().addAll(files);
            HashSet<String> names = new HashSet<String>();
            for (File f : files) {
                names.add(f.getAbsolutePath());
            }
            this.allFiles = FileList.stripNoNBMsNorOSGi(FileList.stripNotExistingFiles(this.getAllFiles()));
            FileList.makePersistent(this.allFiles);
            this.makePersistentCheckedNames(names);
        }

        void removeFile(File file) {
            this.removeFiles(Collections.singleton(file));
        }

        void removeFiles(Collection<File> files) {
            this.getAllFiles().removeAll(files);
            this.allFiles = FileList.stripNoNBMsNorOSGi(FileList.stripNotExistingFiles(this.getAllFiles()));
            FileList.makePersistent(this.allFiles);
            for (File f : files) {
                this.makePersistentUncheckedFile(f);
            }
        }

        private Set<File> loadPresistentState() {
            HashSet<File> retval = new HashSet<File>();
            String files = LocalDownloadSupport.getPreferences().get(LocalDownloadSupport.LOCAL_DOWNLOAD_FILES, null);
            if (files != null) {
                String[] fileArray;
                for (String file : fileArray = files.split(",")) {
                    retval.add(new File(file));
                }
            }
            return retval;
        }

        private boolean isChecked(File f) {
            return this.getCheckedPaths().contains(f.getAbsolutePath());
        }

        private Collection<String> getCheckedPaths() {
            HashSet<String> res = new HashSet<String>();
            String names = LocalDownloadSupport.getPreferences().get(LocalDownloadSupport.LOCAL_DOWNLOAD_CHECKED_FILES, null);
            if (names != null) {
                StringTokenizer st = new StringTokenizer(names, ",");
                while (st.hasMoreTokens()) {
                    res.add(st.nextToken().trim());
                }
            }
            return res;
        }

        private void makePersistentUncheckedFile(File f) {
            if (this.isChecked(f)) {
                Collection<String> newNames = this.getCheckedPaths();
                newNames.remove(f.getAbsolutePath());
                this.makePersistentCheckedNames(newNames);
            }
        }

        private void makePersistentCheckedFile(File f) {
            if (!this.isChecked(f)) {
                Collection<String> newNames = this.getCheckedPaths();
                newNames.add(f.getAbsolutePath());
                this.makePersistentCheckedNames(newNames);
            }
        }

        private void makePersistentCheckedNames(Collection<String> names) {
            StringBuilder sb = null;
            if (!names.isEmpty()) {
                for (String s : names) {
                    if (sb == null) {
                        sb = new StringBuilder(s);
                        continue;
                    }
                    sb.append(", ").append(s);
                }
            }
            if (sb == null) {
                LocalDownloadSupport.getPreferences().remove(LocalDownloadSupport.LOCAL_DOWNLOAD_CHECKED_FILES);
            } else {
                LocalDownloadSupport.getPreferences().put(LocalDownloadSupport.LOCAL_DOWNLOAD_CHECKED_FILES, sb.toString());
            }
        }

        private static void makePersistent(Set<File> files) {
            StringBuilder sb = null;
            if (!files.isEmpty()) {
                for (File file : files) {
                    if (sb == null) {
                        sb = new StringBuilder(file.getAbsolutePath());
                        continue;
                    }
                    sb.append(',').append(file.getAbsolutePath());
                }
            }
            if (sb == null) {
                LocalDownloadSupport.getPreferences().remove(LocalDownloadSupport.LOCAL_DOWNLOAD_FILES);
            } else {
                LocalDownloadSupport.getPreferences().put(LocalDownloadSupport.LOCAL_DOWNLOAD_FILES, sb.toString());
            }
        }

        private static Set<File> stripNotExistingFiles(Set<File> files) {
            HashSet<File> retval = new HashSet<File>();
            for (File file : files) {
                if (!file.exists()) continue;
                retval.add(file);
            }
            return retval;
        }

        private static Set<File> stripNoNBMsNorOSGi(Set<File> files) {
            HashSet<File> retval = new HashSet<File>();
            for (File file : files) {
                if (NBM_FILE_FILTER.accept(file)) {
                    retval.add(file);
                    continue;
                }
                if (!OSGI_BUNDLE_FILTER.accept(file)) continue;
                retval.add(file);
            }
            return retval;
        }
    }

    private static class NbmFileFilter
    extends FileFilter {
        private NbmFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".nbm");
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(LocalDownloadSupport.class, (String)"CTL_FileFilterDescription");
        }
    }

    private static class OsgiBundleFilter
    extends FileFilter {
        private OsgiBundleFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".jar") && LocalDownloadSupport.isOSGiBundle(f);
        }

        @Override
        public String getDescription() {
            return Bundle.CTL_OsgiBundleFilterDescription();
        }
    }
}

