/*
 * Decompiled with CFR 0.152.
 */
package genj.timeline;

import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import genj.almanac.Almanac;
import genj.timeline.TimelineView;
import genj.timeline.TimelineViewSettings;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AlmanacPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger("ancestris.app");
    private final Almanac almanac;
    private final TimelineView view;
    private final TimelineViewSettings.Commit commit;
    private final DefaultListModel<JCheckBox> almanacModel;
    private final DefaultListModel<JCheckBox> categoriesModel;
    private final SpinnerNumberModel spinmodel;
    public static int MAX_SIG = 9;
    public static int MIN_SIG = 0;
    private boolean allCheckedAlms = true;
    private boolean allCheckedCats = true;
    private JButton addButton;
    private JList<JCheckBox> almList;
    private JLabel catLabel;
    private JList<JCheckBox> catList;
    private JScrollPane catScrollPane;
    private JCheckBox cbAllAlms;
    private JCheckBox cbAllCats;
    private JLabel listLabel;
    private JScrollPane listScrollPane;
    private JButton removeButton;
    private JLabel sigLabel;
    private JSpinner sigSpinner;

    public AlmanacPanel(Almanac almanac, TimelineView view, TimelineViewSettings.Commit commit) {
        this.almanac = almanac;
        this.view = view;
        this.commit = commit;
        this.almanacModel = new DefaultListModel();
        this.categoriesModel = new DefaultListModel();
        this.reloadAlmanacs();
        this.reloadCategories();
        int value = Math.min(MAX_SIG, view.getAlmanacSigLevel());
        this.spinmodel = new SpinnerNumberModel(value, MIN_SIG, MAX_SIG, 1);
        this.initComponents();
        this.cbAllAlms.setSelected(this.allCheckedAlms);
        this.cbAllCats.setSelected(this.allCheckedCats);
        this.almList.setCellRenderer(new CheckBoxesListCellrenderer());
        this.catList.setCellRenderer(new CheckBoxesListCellrenderer());
        this.sigSpinner.addChangeListener(commit);
        this.cbAllAlms.addChangeListener(commit);
        this.cbAllCats.addChangeListener(commit);
    }

    private void reloadAlmanacs() {
        Collator comparator = this.view.getCollator();
        comparator.setStrength(0);
        this.almanacModel.removeAllElements();
        List<String> alms = this.almanac.getAlmanacs();
        Collections.sort(alms, comparator);
        List<String> selectedAlm = this.view.getAlmanacList();
        for (String alm : alms) {
            JCheckBox cb = new JCheckBox(alm, selectedAlm.contains(alm));
            if (!cb.isSelected()) {
                this.allCheckedAlms = false;
            }
            cb.addChangeListener(this.commit);
            this.almanacModel.addElement(cb);
        }
        if (this.almList != null) {
            this.almList.setModel(this.almanacModel);
        }
    }

    private void reloadCategories() {
        Collator comparator = this.view.getCollator();
        comparator.setStrength(0);
        ArrayList<String> selectedAlm = new ArrayList<String>(this.getCheckedAlmanacs());
        this.categoriesModel.removeAllElements();
        HashSet set = new HashSet();
        selectedAlm.forEach(alm -> set.addAll(this.almanac.getCategories((String)alm)));
        ArrayList cats = new ArrayList(set);
        Collections.sort(cats, comparator);
        List<String> selectedCat = this.view.getAlmanacCategories();
        for (String cat : cats) {
            JCheckBox cb = new JCheckBox(cat, selectedCat.contains(cat));
            if (!cb.isSelected()) {
                this.allCheckedCats = false;
            }
            cb.addChangeListener(this.commit);
            this.categoriesModel.addElement(cb);
        }
        if (this.catList != null) {
            this.catList.setModel(this.categoriesModel);
        }
    }

    private void checkAllAlms() {
        for (int i = 0; i < this.almanacModel.getSize(); ++i) {
            JCheckBox cb = this.almanacModel.getElementAt(i);
            cb.removeChangeListener(this.commit);
            cb.setSelected(this.cbAllAlms.isSelected());
            cb.addChangeListener(this.commit);
        }
        this.almList.setModel(this.almanacModel);
    }

    private void manageAlmAllCheck() {
        boolean checked = true;
        for (int i = 0; i < this.almanacModel.getSize(); ++i) {
            JCheckBox cb = this.almanacModel.getElementAt(i);
            if (cb.isSelected()) continue;
            checked = false;
        }
        this.cbAllAlms.setSelected(checked);
    }

    private void checkAllCats() {
        for (int i = 0; i < this.categoriesModel.getSize(); ++i) {
            JCheckBox cb = this.categoriesModel.getElementAt(i);
            cb.removeChangeListener(this.commit);
            cb.setSelected(this.cbAllCats.isSelected());
            cb.addChangeListener(this.commit);
        }
        this.catList.setModel(this.categoriesModel);
    }

    private void manageCatAllCheck() {
        boolean checked = true;
        for (int i = 0; i < this.categoriesModel.getSize(); ++i) {
            JCheckBox cb = this.categoriesModel.getElementAt(i);
            if (cb.isSelected()) continue;
            checked = false;
        }
        this.cbAllCats.setSelected(checked);
    }

    public Set<String> getCheckedAlmanacs() {
        HashSet<String> ret = new HashSet<String>();
        for (int i = 0; i < this.almanacModel.getSize(); ++i) {
            JCheckBox cb = this.almanacModel.getElementAt(i);
            if (!cb.isSelected()) continue;
            ret.add(cb.getText());
        }
        return ret;
    }

    public Set<String> getCheckedCategories() {
        HashSet<String> ret = new HashSet<String>();
        for (int i = 0; i < this.categoriesModel.getSize(); ++i) {
            JCheckBox cb = this.categoriesModel.getElementAt(i);
            if (!cb.isSelected()) continue;
            ret.add(cb.getText());
        }
        return ret;
    }

    public int getAlmanacSigLevel() {
        return this.spinmodel.getNumber().intValue();
    }

    private void initComponents() {
        this.listLabel = new JLabel();
        this.cbAllAlms = new JCheckBox();
        this.listScrollPane = new JScrollPane();
        this.almList = new JList<JCheckBox>(this.almanacModel);
        this.catLabel = new JLabel();
        this.cbAllCats = new JCheckBox();
        this.catScrollPane = new JScrollPane();
        this.catList = new JList<JCheckBox>(this.categoriesModel);
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.sigLabel = new JLabel();
        this.sigSpinner = new JSpinner(this.spinmodel);
        Mnemonics.setLocalizedText((JLabel)this.listLabel, (String)NbBundle.getMessage(AlmanacPanel.class, (String)"AlmanacPanel.listLabel.text"));
        this.cbAllAlms.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbAllAlms, (String)NbBundle.getMessage(AlmanacPanel.class, (String)"AlmanacPanel.cbAllAlms.text"));
        this.cbAllAlms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlmanacPanel.this.cbAllAlmsActionPerformed(evt);
            }
        });
        this.almList.setSelectionMode(0);
        this.almList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AlmanacPanel.this.almListMouseClicked(evt);
            }
        });
        this.listScrollPane.setViewportView(this.almList);
        Mnemonics.setLocalizedText((JLabel)this.catLabel, (String)NbBundle.getMessage(AlmanacPanel.class, (String)"AlmanacPanel.catLabel.text"));
        this.cbAllCats.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbAllCats, (String)NbBundle.getMessage(AlmanacPanel.class, (String)"AlmanacPanel.cbAllCats.text"));
        this.cbAllCats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlmanacPanel.this.cbAllCatsActionPerformed(evt);
            }
        });
        this.catList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AlmanacPanel.this.catListMouseClicked(evt);
            }
        });
        this.catScrollPane.setViewportView(this.catList);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(AlmanacPanel.class, (String)"AlmanacPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlmanacPanel.this.addButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(AlmanacPanel.class, (String)"AlmanacPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlmanacPanel.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.sigLabel, (String)NbBundle.getMessage(AlmanacPanel.class, (String)"AlmanacPanel.sigLabel.text"));
        this.sigSpinner.setToolTipText(NbBundle.getMessage(AlmanacPanel.class, (String)"AlmanacPanel.sigSpinner.toolTipText"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.listLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cbAllAlms)).addComponent(this.listScrollPane, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addComponent(this.removeButton, -1, 196, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.catScrollPane, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.sigLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sigSpinner)).addGroup(layout.createSequentialGroup().addComponent(this.catLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cbAllCats))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.listLabel).addComponent(this.catLabel).addComponent(this.cbAllCats).addComponent(this.cbAllAlms)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.listScrollPane, -1, 277, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.addButton)).addComponent(this.catScrollPane)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removeButton).addComponent(this.sigSpinner, -2, 28, -2).addComponent(this.sigLabel)).addContainerGap()));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        File source = new FileChooserBuilder(AlmanacPanel.class.getCanonicalName() + "add").setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(AlmanacPanel.class, (String)"AlmanacPanel.title.add")).setApproveText(NbBundle.getMessage(AlmanacPanel.class, (String)"AlmanacPanel.title.addButton")).setDefaultExtension(FileChooserBuilder.getAlmanacFilter().getExtensions()[0]).setFileFilter((FileFilter)FileChooserBuilder.getAlmanacFilter()).setAcceptAllFileFilterUsed(false).setFileHiding(true).showOpenDialog();
        if (source != null) {
            File dest = new File(this.almanac.getUserDir() + File.separator + source.getName());
            try {
                FileUtils.copyFile((File)source, (File)dest);
                this.almanac.init();
                this.almanac.waitLoaded();
                this.reloadAlmanacs();
                this.reloadCategories();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Error to copy almanach", e);
            }
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Object o;
        File file = new FileChooserBuilder(AlmanacPanel.class.getCanonicalName() + "remove").setFilesOnly(true).setDefaultBadgeProvider().setDefaultWorkingDirectory(this.almanac.getUserDir()).forceUseOfDefaultWorkingDirectory(true).setTitle(NbBundle.getMessage(AlmanacPanel.class, (String)"AlmanacPanel.title.remove")).setApproveText(NbBundle.getMessage(AlmanacPanel.class, (String)"AlmanacPanel.title.removeButton")).setDefaultExtension(FileChooserBuilder.getAlmanacFilter().getExtensions()[0]).setFileFilter((FileFilter)FileChooserBuilder.getAlmanacFilter()).setAcceptAllFileFilterUsed(false).setFileHiding(true).showOpenDialog();
        if (file != null && (o = DialogManager.create((String)NbBundle.getMessage(AlmanacPanel.class, (String)"AlmanacPanel.title.removeconfirm"), (String)NbBundle.getMessage(AlmanacPanel.class, (String)"AlmanacPanel.title.removemsg", (Object)file.getName())).setMessageType(3).setOptionType(0).show()) == DialogManager.YES_OPTION) {
            file.delete();
            this.almanac.init();
            this.almanac.waitLoaded();
            this.reloadAlmanacs();
            this.reloadCategories();
        }
    }

    private void almListMouseClicked(MouseEvent evt) {
        int index = this.almList.locationToIndex(evt.getPoint());
        if (index != -1) {
            JCheckBox cb;
            cb.setSelected(!(cb = this.almanacModel.get(index)).isSelected());
            this.manageAlmAllCheck();
            this.almList.repaint();
            this.reloadCategories();
            this.checkAllCats();
            this.catList.repaint();
            this.commit.stateChanged(new ChangeEvent(this.cbAllCats));
        }
    }

    private void catListMouseClicked(MouseEvent evt) {
        int index = this.catList.locationToIndex(evt.getPoint());
        if (index != -1) {
            JCheckBox cb;
            cb.setSelected(!(cb = this.categoriesModel.get(index)).isSelected());
            this.manageCatAllCheck();
            this.catList.repaint();
        }
    }

    private void cbAllAlmsActionPerformed(ActionEvent evt) {
        this.checkAllAlms();
        this.reloadCategories();
        this.almList.repaint();
        this.cbAllCats.setSelected(true);
        this.checkAllCats();
        this.catList.repaint();
    }

    private void cbAllCatsActionPerformed(ActionEvent evt) {
        this.checkAllCats();
        this.catList.repaint();
    }

    private class CheckBoxesListCellrenderer
    implements ListCellRenderer<JCheckBox> {
        @Override
        public Component getListCellRendererComponent(JList<? extends JCheckBox> list, JCheckBox value, int index, boolean isSelected, boolean cellHasFocus) {
            return value;
        }
    }
}

