/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer.painter;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jxmapviewer.painter.AbstractPainter;
import org.jxmapviewer.painter.Painter;

public class CompoundPainter<T>
extends AbstractPainter<T> {
    private Handler handler;
    private List<Painter<T>> painters = new CopyOnWriteArrayList<Painter<T>>();
    private AffineTransform transform;
    private boolean clipPreserved = false;
    private boolean checkForDirtyChildPainters = true;
    private boolean clearLocalCacheOnly = false;

    public CompoundPainter() {
        this((Painter[])null);
    }

    public CompoundPainter(Painter<T> ... painters) {
        this.handler = new Handler(this);
        this.setPainters(painters);
    }

    public CompoundPainter(List<? extends Painter<T>> painters) {
        this.handler = new Handler(this);
        this.setPainters(painters);
    }

    public void setPainters(List<? extends Painter<T>> painters) {
        ArrayList<Painter<T>> old = new ArrayList<Painter<T>>(this.getPainters());
        for (Painter painter : old) {
            if (!(painter instanceof AbstractPainter)) continue;
            ((AbstractPainter)painter).removePropertyChangeListener(this.handler);
        }
        this.painters.clear();
        this.painters.addAll(painters);
        for (Painter painter : this.painters) {
            if (!(painter instanceof AbstractPainter)) continue;
            ((AbstractPainter)painter).addPropertyChangeListener(this.handler);
        }
        this.setDirty(true);
        this.firePropertyChange("painters", old, this.getPainters());
    }

    public void setPainters(Painter<T> ... painters) {
        List<Object> l = painters == null ? Collections.emptyList() : Arrays.asList(painters);
        this.setPainters(l);
    }

    public void addPainter(Painter<T> painter) {
        ArrayList<Painter<T>> old = new ArrayList<Painter<T>>(this.getPainters());
        this.painters.add(painter);
        if (painter instanceof AbstractPainter) {
            ((AbstractPainter)painter).addPropertyChangeListener(this.handler);
        }
        this.setDirty(true);
        this.firePropertyChange("painters", old, this.getPainters());
    }

    public void removePainter(Painter<T> painter) {
        ArrayList<Painter<T>> old = new ArrayList<Painter<T>>(this.getPainters());
        this.painters.remove(painter);
        if (painter instanceof AbstractPainter) {
            ((AbstractPainter)painter).removePropertyChangeListener(this.handler);
        }
        this.setDirty(true);
        this.firePropertyChange("painters", old, this.getPainters());
    }

    public final Collection<Painter<T>> getPainters() {
        return Collections.unmodifiableCollection(this.painters);
    }

    public boolean isClipPreserved() {
        return this.clipPreserved;
    }

    public void setClipPreserved(boolean shouldRestoreState) {
        boolean oldShouldRestoreState = this.isClipPreserved();
        this.clipPreserved = shouldRestoreState;
        this.setDirty(true);
        this.firePropertyChange("clipPreserved", oldShouldRestoreState, shouldRestoreState);
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform transform) {
        AffineTransform old = this.getTransform();
        this.transform = transform;
        this.setDirty(true);
        this.firePropertyChange("transform", old, transform);
    }

    @Override
    protected void validate(T object) {
        boolean dirty = false;
        for (Painter<T> p : this.painters) {
            if (!(p instanceof AbstractPainter)) continue;
            AbstractPainter ap = (AbstractPainter)p;
            ap.validate(object);
            if (!ap.isDirty()) continue;
            dirty = true;
            break;
        }
        this.clearLocalCacheOnly = true;
        this.setDirty(dirty);
        this.clearLocalCacheOnly = false;
    }

    public boolean isCheckingDirtyChildPainters() {
        return this.checkForDirtyChildPainters;
    }

    public void setCheckingDirtyChildPainters(boolean b) {
        boolean old = this.isCheckingDirtyChildPainters();
        this.checkForDirtyChildPainters = b;
        this.firePropertyChange("checkingDirtyChildPainters", old, this.isCheckingDirtyChildPainters());
    }

    @Override
    protected boolean isDirty() {
        boolean dirty = super.isDirty();
        if (dirty) {
            return true;
        }
        if (this.isCheckingDirtyChildPainters()) {
            for (Painter<T> p : this.painters) {
                AbstractPainter ap;
                if (!(p instanceof AbstractPainter) || !(ap = (AbstractPainter)p).isDirty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void setDirty(boolean d) {
        boolean old = super.isDirty();
        boolean ours = this.isDirty();
        super.setDirty(d);
        if (d != old && d == ours) {
            this.firePropertyChange("dirty", old, this.isDirty());
        }
    }

    @Override
    public void clearCache() {
        if (!this.clearLocalCacheOnly) {
            for (Painter<T> p : this.painters) {
                if (!(p instanceof AbstractPainter)) continue;
                AbstractPainter ap = (AbstractPainter)p;
                ap.clearCache();
            }
        }
        super.clearCache();
    }

    public void clearLocalCache() {
        super.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPaint(Graphics2D g, T component, int width, int height) {
        for (Painter<T> p : this.getPainters()) {
            Graphics2D temp = (Graphics2D)g.create();
            try {
                p.paint(temp, component, width, height);
                if (!this.isClipPreserved()) continue;
                g.setClip(temp.getClip());
            }
            finally {
                temp.dispose();
            }
        }
    }

    @Override
    protected void configureGraphics(Graphics2D g) {
        AffineTransform tx = this.getTransform();
        if (tx != null) {
            g.setTransform(tx);
        }
    }

    @Override
    protected boolean shouldUseCache() {
        return super.shouldUseCache();
    }

    private static class Handler
    implements PropertyChangeListener {
        private final WeakReference<CompoundPainter<?>> ref;

        public Handler(CompoundPainter<?> painter) {
            this.ref = new WeakReference(painter);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CompoundPainter painter = (CompoundPainter)this.ref.get();
            if (painter == null) {
                AbstractPainter src = (AbstractPainter)evt.getSource();
                src.removePropertyChangeListener(this);
            } else {
                String property = evt.getPropertyName();
                if ("dirty".equals(property) && evt.getNewValue() == Boolean.FALSE) {
                    return;
                }
                painter.setDirty(true);
            }
        }
    }
}

