/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.gedcomconversion;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.modules.editors.gedcomconversion.ConversionPanel;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import java.awt.event.ActionEvent;
import java.util.List;
import org.openide.util.NbBundle;

public class ConversionAction
extends AbstractAncestrisContextAction {
    private static String DEFAULT_ICON = "ancestris/modules/editors/gedcomconversion/Conversion.png";
    private static String GRAMMAR55_ICON = "ancestris/modules/editors/gedcomconversion/Conversion55.png";
    private static String GRAMMAR551_ICON = "ancestris/modules/editors/gedcomconversion/Conversion551.png";
    private static String GRAMMAR70_ICON = "ancestris/modules/editors/gedcomconversion/Conversion7.png";

    public ConversionAction() {
        this.setText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ConversionAction"));
        this.setTip(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_ConversionAction"));
        this.setIconBase(DEFAULT_ICON);
    }

    public ConversionAction(Context context) {
        this();
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        this.setIconBase(this.getIconStringFromGrammar(this.contextProperties));
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        new ConversionPanel(this.getContext().getGedcom()).execute();
    }

    private String getIconStringFromGrammar(List<Property> contextProperties1) {
        String ret = "";
        if (!this.contextProperties.isEmpty()) {
            Gedcom gedcom = ((Property)this.contextProperties.get(0)).getGedcom();
            if (gedcom == null) {
                return DEFAULT_ICON;
            }
            Grammar grammar = gedcom.getGrammar();
            ret = grammar.equals(Grammar.V551) ? GRAMMAR551_ICON : (grammar.equals(Grammar.V55) ? GRAMMAR55_ICON : (grammar.equals(Grammar.V70) ? GRAMMAR70_ICON : DEFAULT_ICON));
        } else {
            ret = DEFAULT_ICON;
        }
        return ret;
    }
}

