/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome.content;

import ancestris.welcome.content.LinkButton;
import ancestris.welcome.content.Utils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import org.openide.awt.StatusDisplayer;

public class ActionButton
extends LinkButton {
    private Action action;
    private String urlString;
    private boolean visited = false;
    private static final long serialVersionUID = 1L;

    public ActionButton(Action a, String urlString, boolean showBorder, String usageTrackingId) {
        this(a, urlString, Utils.getColor("LinkColor"), showBorder, usageTrackingId);
    }

    public ActionButton(Action a, String urlString, Color foreground, boolean showBorder, String usageTrackingId) {
        super(a.getValue("Name").toString(), foreground, showBorder, usageTrackingId);
        Object tooltip;
        this.action = a;
        this.urlString = urlString;
        Object icon = a.getValue("SmallIcon");
        if (null != icon && icon instanceof Icon) {
            this.setIcon((Icon)icon);
        }
        if (null != (tooltip = a.getValue("ShortDescription"))) {
            this.setToolTipText(tooltip.toString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.logUsage();
        if (null != this.action) {
            this.action.actionPerformed(e);
        }
        if (null != this.urlString) {
            this.visited = true;
        }
    }

    @Override
    protected void onMouseExited(MouseEvent e) {
        if (null != this.urlString) {
            StatusDisplayer.getDefault().setStatusText("");
        }
    }

    @Override
    protected void onMouseEntered(MouseEvent e) {
        if (null != this.urlString) {
            StatusDisplayer.getDefault().setStatusText(this.urlString);
        }
    }

    @Override
    protected boolean isVisited() {
        return this.visited;
    }
}

