#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import gettext
_ = gettext.gettext
gettext.bindtextdomain("desktop-menu","/usr/share/locale")
gettext.textdomain("desktop-menu")


#Lib file containing all of the strings within desktop-menu.
#   All strings that include characters such as {0} {1} {2} indicate positions where information is inserted.
#   All strings that include \n indicate a new line at that position. 
#       If a new line is not needed or more are needed this can be moved / added / removed to accomodate.
#       Only applicable to lines that specify the use of \n (otherwise \n will be displayed as text)

################################################################################
#### Help display options h = help, # = string number, (_a-z) = sub string #####
################################################################################

# Usage line, single word in square brackets.
h1=_("options")

# Main help header entry.
h1_a=_("Script rebuilding and refreshing the menus for all installed window managers from template files.")

# Help Section header entry for locale options section.
h2=_("Locale")

# Help Section header entry for filtering options section.
h3=_("Filtering")

# Help section header entry for options that manipulate the menu output
h4=_("Specify Menu Type")

# Help section header entry for utility options
h5=_("Utilities")

# Help section header entry for how icons are found and used in the menu output
h6=_("Icon Setting")

# Help section header entry for how information is displayed
h7=_("Behaviour")

# Help section header entry for manipulating configuration file settings
h8=_("Configuration file")

# Description of --text-length
h9=_("Specify menu text character length limit")

# Help section header entry
h10=_("Help and Information")

# Description of option --locale=
h11=_("Overwrite default output language and encoding. Use either full Unix locale style (e.g. fr_BE.UTF-8) or abbreviations (e.g. fr_BE). Defaults to your session locale if this option is omitted.")

# Description of option --root-folder=
h12=_("Folder to generate (for example: Games). This will be a submenu within the menu file specified")

# Description of option --show-hidden
h13=_("Show menu items marked NoDisplay=True in the .desktop file. Default is hidden")

# Description of option --menu-file=
h14=_("Specify the xdg menu file to use. Default: desktop-menu-applications.menu")

# Description of option --desktop-code= (WM = Window Manager)
h15=_("Specify which window manager you are using, e.g.: icewm, fluxbox, jwm, etc... (Requires matching template!)")

# Description of option --category-filter= (Followed by a list of values. In this entry you can use \n to append additional lines. No leading blanks needed.)
h16=_("Apply filter on --order to the menu categories. Default is “ngc” (Names, Generic Names, Comments)")

# Subtext explanation of --category-filter 
h16_a=("Any one (n) or combination (cn) can be used")

# Subtext header for list of valid entries of --category-filter
h16_b=_("Values:")

# Subtext option value for --category-filter. Single word used in lists of valid entries and examples. Name= option in a .desktop file
h16_c=_("Name")

# Subtext option value for --category-filter. Single expression used in lists of valid entries and examples. GenericName= option in a .desktop file
h16_d=_("Generic Name")

# Subtext option value for --category-filter. Single expression used in lists of valid entries and examples. Comment= option in a .desktop file
h16_e=_("Comment")

# Description of option --order. (In this entry you may use \n to append additional lines when desired in translation. No leading blanks needed.)
h17=_("Specify type and order of text entries displayed in menus. \nDefault is “n” (Names) if omitted.")

# Subtext explanation of option --order 
h17_a=("Like --category-filter, Any one (n) or combination (ngc) can be used")

# Subtext header for list of valid entries of --order (currently same as --category-filter but can be changed to a separate text)
# h17_b=_("Different text here")
h17_b=h16_b

# Subtext option value for --order. Single word used in lists of valid entries and examples. Name= option in a .desktop file
# Currently identical to --category-filter. Can be made different
h17_c=h16_c

# Subtext option value for --order. Single expression used in lists of valid entries and examples. GenericName= option in a .desktop file
# Currently identical to --category-filter. Can be made different
h17_d=h16_d

# Subtext option value for --order. Single expression used in lists of valid entries and examples. Comment= option in a .desktop file
# Currently identical to --category-filter. Can be made different
h17_e=h16_e

# Description of option --separators. (In this entry you may use \n to append additional lines when desired in translation. No leading blanks needed.)
h18=_("Specify the type, arrangement, and style of any separators used between the options specified in --order \n6 separators total must be assigned \nShell special charecters must be escaped. \nExample if order is ngc: --separators={0} becomes: |Name|(Generic Name)[Comment] \n")
# Example option text used in {0} of above line
h18a=r"\| \| \( \) [ ]"

# Description of option --sep_1a= (Substitution: {0} = --order)
h19=_("Specify separator string before 1st entity given in {0}.")

# Description of option --sep_1b= (Substitution: {0} = --order) 
h20=_("Specify separator string behind 1st entity given in {0}.")

# Description of option --sep_2a= (Substitution: {0} = --order)
h21=_("Specify separator string before 2nd entity given in {0}.")

# Description of option --sep_2b=  (Substitution: {0} = --order)
h22=_("Specify separator string behind 2nd entity given in {0}.")

# Description of option --sep_3a= (Substitution: {0} = --order)
h23=_("Specify separator string before 3rd entity given in {0}.")

# Description of option --sep_3b= (Substitution: {0} = --order)
h24=_("Specify separator string behind 3rd entity given in {0}.")

# Subtext Header of separator section to list of examples)
h24_a=_("Examples:")

# Subtext of separator section used in examples for placement in separators. Example where separators are [](){}; [first entity] ( second entity ) {third entity}
h24_b=_("first entity")

# Subtext of separator section used in examples for placement in separators. Example where separators are [](){}; [first entity] ( second entity ) {third entity}
h24_c=_("second entity")

# Subtext of separator section used in examples for placement in separators. Example where separators are [](){}; [first entity] ( second entity ) {third entity}
h24_d=_("third entity")

# Please do not translate "sep-...", this refers to sep-1a= to sep-3b= options. Following line demonstrates the three entries Name, Generic Name and Comment will get glued together resulting from omitting all sep-... options when using --order.
h24_e=_("No sep-... specified at all")

# Footer text trailing all 6 --sep-... options. In this entry you may add lines in translation when desired, by appending \n without need of leading blanks, max. 56 characters per line.
h24_f=_("It is important to put the separator characters/strings into the\nentity numbers to which these belong, in order to allow them get\nremoved automatically if an respective text string entry is empty.\nAs a rule of thumb put all non embracing characters into the “a” entry\nof the following entity number, and closing brackets into the\n“b” entry of the entity number to which the embracement belongs.\nThe complete pattern is built up as follows:")

# Footer text trailing all 6 --sep-... options.
h24_g=_("In case an entity is empty the respective separators will get removed also.")

# Description of option --terminal (Substitution: {0] = example desktop emulator start command)
h25=_("Set terminal emulator command to use in menu (default: {0}).")

# Description of option --write-out
h26=_("The output is written to the user specific menu files from the appropriate templates corresponding to the respective window managers. Status quo merely entries in the menu “Programmes” and its submenus are subject to be modified.")

# Description of option --global
h27=_("The output is for all users of the system — taking into account their respective menu configuration, if present, and the language of their user interface. If --write-out is also passed, the output will be written to the user specific files within the system cache location (Default: /var/cache/desktop-menu/)")

# Description of option --write-out-file. (Substitution: {0} = name of the template files)
h28=_("Specify the file name of the files to be used instead of the standard templates (“{0}” in various directories corresponding to the window managers).")

# Description of option --write-out-folder.
h29=_("Folder which will contain the write out file")

# Description of option --write-all-menus.
h30=_("Write menus for all of the supported window managers available '1' or only the active window manager '0'")

# Description of option --no-gtk
h31=_("Turn off using gtk to find the menu icons")

# Description of option --gtk-theme 
h32=_("Set icon theme to specified name")

# Description of option --icon-size= (Substitution: {0} = Size value)
h33=_("Overwrite default icon size. (This is {0} by default.)")

# Description of option --no-icons
h34=_("Turns off Icons")

# Description of option --icons-only
h35=_("Only use icons, no text for the menu entries")

# Description of option --theme-only (Substitutions: {0} and {1} = paths to folders {2} = reference)
h36=_("Do not search all icon themes for substitution of missing named icons (see “{2}”). Instead, use the icon “missing symbol” if an icon is not found in the currently used gtk theme set in {0} or {1} folders.")

# Description of option --no-print
h37=_("Suppress printing menu output to screen")

# Description of option --verbose
h38=_("Print information messages to screen")

# Description of option --debug
h39=_("Print debug messages to screen")

# Description of option --config-folder
h40=_("Folder to find desktop-menu configuration. Based in the user's home directory. Default: .config/desktop-menu")

# Description of option --config-file
h41=_("Filename storing desktop-menu configuration")

# Description of option --help 
h43=_("Display this usage help message and exit")

# Description of option --version
h44=_("Show version info and exit")

# Description of option --no-config
h45=_("Do not load the configuration file")

################################################################################
### Error options me = message error, # = string number, (_a-z) = sub string ###
################################################################################

# Starting text used for errors. Used when an error has occured. Example ('Error:' no file found)
me0=_("Error: {0}")

# Message when attempting to continue due to global write
me0a=_("Attempting to continue")

# Error message when there was no desktop code specified or found before exiting
me1=_("No Desktop Code. Please specify a desktop code with --desktop-code")

# Error message when trying to run the option --global when you are not the root user
me2=_("You need to be root to write a menu globally to all users")

# Error message when trying to build a menu as root without the --global option. 
me3=_("Does the root user need a menu? Maybe --global option was meant to be used")

# Error message when a locale string is unusable. {0} is the locale tried {1} is a list of usable locales
me4=_("The locale: {0} does not appear to be usable. \nMaybe try one of these: {1}")


################################################################################
# Verbose options mv = message verbose, # = string number, (_a-z) = sub string #
################################################################################

# Warning message when the gtk theme found or specified cannot be used. (Substitutions: {0} is the name of the failed icon theme)
mv1=_("Warning: Could not set gtk icon theme {0}. Trying to fetch the default hicolor theme")

# Standard message when --global and --write-out are used so some message of progress is seen. (Substitutions: {0} Name of user)
mv2=_("Building menus for: {0}")

# Error message when the number of available separators is below 6
mv3=_("Separator length too low, adding ?")


################################################################################
### Debug options md = message debug, # = string number, (_a-z) = sub string ###
################################################################################

# Starting text used when displaying debug messages. Example ( 'Debug:' updating user files) (Substitutions: {0} = debug message)
md0=_("Debug: {0}")

# Debug Message: for when running the argument parser and variable initiation 
md1=_("Namespace init and agrument parsing ran")

# Debug Message; label to show the icon theme (Example: Icon Theme: papirus-mini-antix)
md2=_("Icon Theme:")

#Debug Message; to display desktop code and window manager (Subsitutions: {0} = window manager, {1} = desktop code)
md3=_("Found {0} window manager from {1} desktop code")

#Debug Message; display of valid window managers (Substitutions: {0} = list of found window managers that have a template and have an executable)
md4=_("Valid Window Managers: {0}")

#Debug Message; display the locale used (Substitutions: {0} = locale found or specified)
md5=_("Locale: {0}")

#Debug Message; display of directory verification of existence and permissions. (Substitutions: {0} = directory, {1} = user ID, {2} = group ID)
md6=_("Verifying directory: {0} as owner: {1} and group: {2}")

#Debug Message; display showing the global options function is being run
md7=_("Setting global options")

#Debug Message; display showing the user options function is being run
md8=_("Setting user options")

#Debug Message; notifying that a user configuration file was found
md9=_("Configuration File Exists!")

#Debug Message; diplay showing the initialization of user configuration is being run
md10=_("Setting initial user configuration")

#Debug Message; display showing the configuration file is being read. (Substitutions: {0} = configuration file)
md11=_("Reading configuration file: {0}")

#Debug Message; display showing the window manager template file is being read. (Substitutions: {0} = template folder, {1} window manager)
md12=_("Reading template file: {0}{1}.template")

#Debug Message; display of the text separators being used (Substitutions: {0} = list of separators)
md13=_("Separators: {0} ")

#Debug Message; display of category filters being used (Substitutions: {0} = category filter 
md14=_("Category Filter: '{0}' ")

#Debug Message; display of the text order (Substitutions: {0} = list of --order options)
md15=_("Text Order: {0} ")

#Debug Message; display of where the outputted menu is being written to. (Substitutions: {0} =  file and path, {1} = separator line for easier readout
md16=_("Writing out to: {0}\n{1}")

#Debug Message; display of menu information arrays being built (Substitutions: {0} = User 
md17=_("Building menu arrays for {0}")

#Debug Message; display of xdg menu file being used (Substitutions: {0} = xdg menu file
md18=_("Menu File: {0}")

#Debug Message; display of number of users found in the 'users' group (Substitutions: {0} number of users)
md19=_("{0} users found in users group")

#Debug Message; display of the user's home directory being used (Substitutions: {0} = user's home directory)
md20=_("Home Directory: {0}")

#Debug Message; display of the user's ID (Substitution: {0} = user's ID number )
md21=_("Current UID: {0}")

#Debug Message; display of the user's group ID (Substitutions: {0} user's group ID number )
md22=_("Current GID: {0}")

#Debug Message; display of the user name the later code will be run as (Substitutions: {0} = user name ) 
md23=_("Running as user: {0}")

#Debug Message; display that the antix desktop file improvement module was found installed, and desktop-menu has imported and will run the module
md24=_("Desktop Files improvement module found and imported....... Running.")


#Warning Message; message written to the top of the output file to warn users that desktop-menu may overwrite changes manually made to the file
oh1=_("This is a system generated file. All changes may be overwritten by desktop-menu")
